package com.biz.crm.sfa.business.data.sample.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.sfa.business.data.sample.local.entity.DataSampleEntity;
import com.biz.crm.sfa.business.data.sample.local.mapper.DataSampleMapper;
import com.biz.crm.sfa.business.data.sample.local.model.DataSampleConditionModel;
import com.biz.crm.sfa.business.data.sample.sdk.dto.DataSamplePageDto;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 数据示例表的数据库访问类 {@link DataSampleEntity}
 *
 * @author ning.zhang
 * @date 2022-07-27 16:15:09
 */
@Component
public class DataSampleRepository extends ServiceImpl<DataSampleMapper, DataSampleEntity> {

  /**
   * 多条件查询数据示例列表
   *
   * @param model 条件model
   * @return 数据示例列表
   */
  public List<DataSampleEntity> findByDataSampleConditionModel(DataSampleConditionModel model) {
    return this.baseMapper.findByDataSampleConditionModel(model);
  }
  /**
   * 批量删除
   *
   * @param ids ID集合
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(DataSampleEntity::getId, ids)
        .set(DataSampleEntity::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }

  /**
   * 批量更新启用禁用状态
   *
   * @param ids          ID集合
   * @param enableStatus 启用禁用状态
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enableStatus) {
    this.lambdaUpdate()
        .in(DataSampleEntity::getId, ids)
        .set(DataSampleEntity::getEnableStatus, enableStatus.getCode())
        .update();
  }

  /**
   * 数据示例分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<DataSampleEntity> 数据示例分页信息
   */
  public Page<DataSampleEntity> findByConditions(Pageable pageable, DataSamplePageDto dto) {
    Page<DataSampleEntity> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findByConditions(page, dto);
  }
}
