package com.biz.crm.sfa.business.data.sample.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.data.sample.local.entity.DataSampleEntity;
import com.biz.crm.sfa.business.data.sample.sdk.dto.DataSampleDto;
import com.biz.crm.sfa.business.data.sample.sdk.dto.DataSamplePageDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 数据示例表服务接口
 *
 * @author ning.zhang
 * @date 2022-07-27 16:15:09
 */
public interface DataSampleService {

  /**
   * 创建数据示例
   *
   * @param dto 请求参数dto
   * @return 数据示例实体
   */
  DataSampleEntity create(DataSampleDto dto);

  /**
   * 更新数据示例
   *
   * @param dto 请求参数dto
   * @return 数据示例实体
   */
  DataSampleEntity update(DataSampleDto dto);

  /**
   * 批量删除数据示例
   *
   * @param ids 数据示例id集合
   */
  void deleteBatch(List<String> ids);

  /**
   * 批量启用数据示例
   *
   * @param ids 数据示例id集合
   */
  void enableBatch(List<String> ids);

  /**
   * 批量禁用数据示例
   *
   * @param ids 数据示例id集合
   */
  void disableBatch(List<String> ids);

  /**
   * 数据示例分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<DataSampleEntity> 数据示例分页信息
   */
  Page<DataSampleEntity> findByConditions(Pageable pageable, DataSamplePageDto dto);

  /**
   * 通过ID查询数据示例信息
   *
   * @param id ID
   * @return 数据示例信息
   */
  DataSampleEntity findById(String id);
}
