package com.biz.crm.sfa.business.data.sample.local.service.internal;

import com.biz.crm.sfa.business.data.sample.local.entity.DataSampleEntity;
import com.biz.crm.sfa.business.data.sample.local.repository.DataSamplePictureRepository;
import com.biz.crm.sfa.business.data.sample.local.service.DataSamplePictureService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

/**
 * 数据示例照片表服务实现类
 *
 * @author ning.zhang
 * @date 2022-07-27 16:15:10
 */
@Slf4j
@Service("dataSamplePictureService")
public class DataSamplePictureServiceImpl implements DataSamplePictureService {

  @Autowired
  private DataSamplePictureRepository dataSamplePictureRepository;

  @Override
  @Transactional
  public void update(DataSampleEntity sampleEntity) {
    Validate.notBlank(sampleEntity.getId(), "数据示例ID不能为空");
    this.dataSamplePictureRepository.deleteBySampleId(sampleEntity.getId());
    if (CollectionUtils.isEmpty(sampleEntity.getPictureList())) {
      return;
    }
    this.updateValidation(sampleEntity);
    this.dataSamplePictureRepository.saveBatch(sampleEntity.getPictureList());
  }

  /**
   * 在修改DataSamplePicture模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   *
   * @param sampleEntity 检查对象
   */
  private void updateValidation(DataSampleEntity sampleEntity) {
    sampleEntity.getPictureList().forEach(entity -> {
      entity.setId(null);
      entity.setSampleId(sampleEntity.getId());
      entity.setTenantCode(sampleEntity.getTenantCode());
      entity.setSortIndex(sampleEntity.getPictureList().indexOf(entity) + 1);
      Validate.notBlank(entity.getFileCode(), "缺失文件唯一识别号");
    });
  }
}
