package com.biz.crm.sfa.business.data.sample.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.sfa.business.data.sample.local.entity.DataSampleEntity;
import com.biz.crm.sfa.business.data.sample.local.model.DataSampleConditionModel;
import com.biz.crm.sfa.business.data.sample.local.repository.DataSampleRepository;
import com.biz.crm.sfa.business.data.sample.sdk.service.DataSampleVoService;
import com.biz.crm.sfa.business.data.sample.sdk.vo.DataSampleVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * 数据示例Vo服务接口实现类
 *
 * @author ning.zhang
 * @date 2022/7/27
 */
@Slf4j
@Service
public class DataSampleVoServiceImpl implements DataSampleVoService {

  @Autowired
  private DataSampleRepository dataSampleRepository;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public List<DataSampleVo> findBySampleCodes(Set<String> sampleCodes) {
    if (CollectionUtils.isEmpty(sampleCodes)) {
      return Lists.newLinkedList();
    }
    DataSampleConditionModel model = new DataSampleConditionModel();
    model.setSampleCodes(sampleCodes);
    model.setTenantCode(TenantUtils.getTenantCode());
    model.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    List<DataSampleEntity> entities = this.dataSampleRepository.findByDataSampleConditionModel(model);
    if (CollectionUtils.isEmpty(entities)) {
      return Lists.newLinkedList();
    }
    return (List<DataSampleVo>) this.nebulaToolkitService.copyCollectionByBlankList(entities, DataSampleEntity.class
        , DataSampleVo.class, HashSet.class, ArrayList.class);
  }
}
