package com.biz.crm.sfa.business.data.sample.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Transient;
import java.util.List;

/**
 * 数据示例Dto
 *
 * @author ning.zhang
 * @date 2022/7/27
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "DataSampleDto", description = "数据示例Dto")
public class DataSampleDto extends TenantDto {

  /**
   * 示例编码
   */
  @ApiModelProperty("示例编码")
  private String sampleCode;

  /**
   * 示例名称
   */
  @ApiModelProperty("示例名称")
  private String sampleName;

  /**
   * 示例类型
   */
  @ApiModelProperty("示例类型")
  private String sampleType;

  /**
   * 排序(值越小越靠前)
   */
  @ApiModelProperty("排序(值越小越靠前)")
  private Integer sortIndex;

  /**
   * 描述
   */
  @ApiModelProperty("描述")
  private String description;

  /**
   * 示例照片
   */
  @ApiModelProperty("示例照片")
  @Transient
  @TableField(exist = false)
  private List<DataSamplePictureDto> pictureList;
}
