package com.biz.crm.sfa.business.data.sample.sdk.event;

import com.biz.crm.sfa.business.data.sample.sdk.vo.DataSampleVo;

import java.util.List;

/**
 * 数据示例事件通知
 *
 * @author ning.zhang
 * @date 2022/7/27
 */
public interface DataSampleEventListener {

  /**
   * 当数据示例新增时触发
   *
   * @param vo 数据示例信息
   */
  void onCreate(DataSampleVo vo);

  /**
   * 当数据示例修改时触发
   *
   * @param oldVo 修改之前的vo
   * @param newVo 修改之后的vo
   */
  void onUpdate(DataSampleVo oldVo, DataSampleVo newVo);

  /**
   * 当数据示例禁用时触发
   *
   * @param voList 禁用vo信息
   */
  void onDisable(List<DataSampleVo> voList);

  /**
   * 当数据示例启用时触发
   *
   * @param voList 禁用vo信息
   */
  void onEnable(List<DataSampleVo> voList);

  /**
   * 当数据示例删除时触发
   *
   * @param voList 删除vo信息
   */
  void onDelete(List<DataSampleVo> voList);
}
