package com.biz.crm.sfa.business.data.sample.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 数据示例Vo
 *
 * @author ning.zhang
 * @date 2022/7/27
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "DataSampleVo", description = "数据示例Vo")
public class DataSampleVo extends TenantFlagOpVo {

  private static final long serialVersionUID = -2797470401354769717L;

  /**
   * 示例编码
   */
  @ApiModelProperty("示例编码")
  private String sampleCode;

  /**
   * 示例名称
   */
  @ApiModelProperty("示例名称")
  private String sampleName;

  /**
   * 示例类型
   */
  @ApiModelProperty("示例类型")
  private String sampleType;

  /**
   * 排序(值越小越靠前)
   */
  @ApiModelProperty("排序(值越小越靠前)")
  private Integer sortIndex;

  /**
   * 描述
   */
  @ApiModelProperty("描述")
  private String description;

  /**
   * 示例照片
   */
  @ApiModelProperty("示例照片")
  private List<DataSamplePictureVo> pictureList;
}
