package com.biz.crm.sfa.business.help.defense.local.controller;


import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.help.defense.local.entity.HelpDefensePlanDetailException;
import com.biz.crm.sfa.business.help.defense.local.service.HelpDefensePlanDetailExceptionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 协访计划明细异常表(HelpDefensePlanDetailException)表相关的http接口
 *
 * @author songjingen
 * @since 2022-06-28 20:08:22
 */
@RestController
@RequestMapping("/v1/helpDefense/helpDefensePlanDetailException")
@Slf4j
@Api(tags = "协访管理：HelpDefensePlanDetailException：协访计划明细异常表")
public class HelpDefensePlanDetailExceptionController {
  /**
   * 服务对象
   */
  @Autowired
  private HelpDefensePlanDetailExceptionService helpDefensePlanDetailExceptionService;

  /**
   * 通过协访计划编码查询数据
   *
   * @param helpPlanDetailId 主键
   * @return 单条数据
   */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("findByHelpPlanDetailId")
  public Result<HelpDefensePlanDetailException> findByHelpPlanDetailId(@ApiParam(name = "helpPlanDetailId", value = "协访计划明细主键") @RequestParam("helpPlanDetailId") String helpPlanDetailId) {
    try {
      HelpDefensePlanDetailException helpDefensePlanDetailException = this.helpDefensePlanDetailExceptionService.findByHelpPlanDetailId(helpPlanDetailId);
      return Result.ok(helpDefensePlanDetailException);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 新增数据
   *
   * @param helpDefensePlanDetailException 实体对象
   * @return 新增结果
   */
  @ApiOperation(value = "新增数据")
  @PostMapping
  public Result<HelpDefensePlanDetailException> create(@ApiParam(name = "helpDefensePlanDetailException", value = "协访计划明细异常表") @RequestBody HelpDefensePlanDetailException helpDefensePlanDetailException) {
    try {
      HelpDefensePlanDetailException result = this.helpDefensePlanDetailExceptionService.create(helpDefensePlanDetailException);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
