package com.biz.crm.sfa.business.help.defense.local.controller;


import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.help.defense.local.entity.HelpDefensePlanDetailPerformance;
import com.biz.crm.sfa.business.help.defense.local.service.HelpDefensePlanDetailPerformanceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 协访计划明细完成表(HelpDefensePlanDetailPerformance)表相关的http接口
 *
 * @author songjingen
 * @since 2022-06-07 15:43:21
 */
@RestController
@RequestMapping("/v1/helpDefense/detailPerformance")
@Slf4j
@Api(tags = "协访管理：HelpDefensePlanDetailPerformance：协访计划明细完成表")
public class HelpDefensePlanDetailPerformanceController {
  /**
   * 服务对象
   */
  @Autowired
  private HelpDefensePlanDetailPerformanceService helpDefensePlanDetailPerformanceService;

  /**
   * 根据拜访计划明细主键查询已完成表单数据
   *
   * @param id 主键
   * @return
   */
  @GetMapping("findByDetailId")
  @ApiOperation(value = "根据拜访计划明细主键查询已完成表单数据")
  public Result<List<HelpDefensePlanDetailPerformance>> findByDetailId(@ApiParam(name = "id", value = "明细主键") @RequestParam("id") String id) {
    try {
      List<HelpDefensePlanDetailPerformance> list = this.helpDefensePlanDetailPerformanceService.findByDetailId(id);
      return Result.ok(list);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
