package com.biz.crm.sfa.business.help.defense.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.help.defense.sdk.dto.HelpDefensePlanDetailPageDto;
import com.biz.crm.sfa.business.help.defense.sdk.service.HelpDefensePlanDetailVoService;
import com.biz.crm.sfa.business.help.defense.sdk.vo.HelpDefensePlanDetailVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 协访计划明细表(HelpDefensePlanDetail)表相关的http接口
 *
 * @author songjingen
 * @since 2022-06-07 15:43:21
 */
@RestController
@RequestMapping("/v1/helpDefense/helpDefensePlanDetailVo")
@Slf4j
@Api(tags = "协访管理:HelpDefensePlanDetailVo:协访计划明细表")
public class HelpDefensePlanDetailVoController {
  /**
   * 服务对象
   */
  @Autowired
  private HelpDefensePlanDetailVoService helpDefensePlanDetailVoService;

  /**
   * 分页查询所有数据
   *
   * @param pageable 分页对象
   * @param dto      查询实体
   * @return 所有数据
   */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<HelpDefensePlanDetailVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                @ApiParam(name = "dto", value = "查询对象") HelpDefensePlanDetailPageDto dto) {
    try {
      Page<HelpDefensePlanDetailVo> page = this.helpDefensePlanDetailVoService.findByConditions(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
