package com.biz.crm.sfa.business.help.defense.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import com.biz.crm.sfa.business.client.sdk.register.ClientRouteRegister;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 协访计划客户信息表
 *
 * @author songjingen
 */
@Getter
@Setter
@Entity
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_help_defense_client_info")
@Table(name = "sfa_help_defense_client_info")
@ApiModel(value = "HelpDefenseClientInfo", description = "协访计划客户信息表")
@org.hibernate.annotations.Table(appliesTo = "sfa_help_defense_client_info", comment = "协访计划客户信息表")
public class HelpDefenseClientInfo extends UuidEntity {

  private static final long serialVersionUID = -4442779125977878918L;

  /**
   * 协访计划编码
   */
  @ApiModelProperty("协访计划编码")
  @Column(name = "help_plan_code", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '协访计划编码'")
  private String helpPlanCode;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  @Column(name = "client_code", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '客户编码'")
  private String clientCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  @Column(name = "client_Name", length = 64, columnDefinition = "varchar(255) COMMENT '客户名称'")
  private String clientName;

  /**
   * 客户类型
   * {@link ClientTypeEnum#getDictCode()}
   */
  @ApiModelProperty("客户类型")
  @Column(name = "client_type", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '客户类型'")
  private String clientType;

  /**
   * 客户维度
   * {@link ClientRouteRegister#getKey()}
   */
  @ApiModelProperty("客户维度")
  @Column(name = "client_route", length = 255, nullable = false, columnDefinition = "varchar(64) COMMENT '客户维度'")
  private String clientRoute;

}
