package com.biz.crm.sfa.business.help.defense.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import com.biz.crm.sfa.business.client.sdk.register.ClientRouteRegister;
import com.biz.crm.sfa.business.help.defense.sdk.enums.HelpStatusEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.Date;

/**
 * 协访计划明细 实体类
 *
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("sfa_help_defense_plan_detail")
@Table(name = "sfa_help_defense_plan_detail")
@ApiModel(value = "HelpDefensePlanDetail", description = "协访计划明细表")
@org.hibernate.annotations.Table(appliesTo = "sfa_help_defense_plan_detail", comment = "协访计划明细表")
public class HelpDefensePlanDetail extends UuidOpEntity {

  private static final long serialVersionUID = 7022214277071025864L;
  /**
   * 协访计划编码
   */
  @ApiModelProperty("协访计划编码")
  @Column(name = "help_plan_code", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '协访计划编码'")
  private String helpPlanCode;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  @Column(name = "client_code", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '客户编码'")
  private String clientCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户编码")
  @Column(name = "client_name", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '客户名称'")
  private String clientName;

  /**
   * 客户类型
   * {@link ClientTypeEnum#getDictCode()}
   */
  @ApiModelProperty("客户类型")
  @Column(name = "client_type", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '客户类型'")
  private String clientType;

  /**
   * 客户维度
   * {@link ClientRouteRegister#getKey()}
   */
  @ApiModelProperty("客户维度")
  @Column(name = "client_route", length = 255, nullable = false, columnDefinition = "varchar(64) COMMENT '客户维度'")
  private String clientRoute;

  /**
   * 协访状态
   * {@link HelpStatusEnum#getDictCode()}
   */
  @ApiModelProperty("协访状态")
  @Column(name = "help_status", length = 64, nullable = false, columnDefinition = "varchar(255) COMMENT '协访状态'")
  private String helpStatus;

  /**
   * 协访日期
   */
  @ApiModelProperty("协访日期")
  @Column(name = "help_date", length = 20, nullable = false, columnDefinition = "date COMMENT '协访日期'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date helpDate;

  /**
   * 协访开始时间
   */
  @ApiModelProperty("协访开始时间")
  @Column(name = "help_start_date", length = 20, columnDefinition = "datetime COMMENT '协访开始时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date helpStartDate;

  /**
   * 协访结束时间
   */
  @ApiModelProperty("协访结束时间")
  @Column(name = "help_end_date", length = 20, columnDefinition = "datetime COMMENT '协访结束时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date helpEndDate;

  /**
   * 被协访人员账号
   */
  @ApiModelProperty("被协访人员账号")
  @Transient
  @TableField(exist = false)
  private String coverHelpUserName;

  /**
   * 协访人员账号
   */
  @ApiModelProperty("协访人员账号")
  @Transient
  @TableField(exist = false)
  private String helpUserName;


}
