package com.biz.crm.sfa.business.help.defense.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.List;

/**
 * 协访计划明细异常 实体类
 *
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("sfa_help_defense_plan_detail_exception")
@Table(name = "sfa_help_defense_plan_detail_exception", indexes = {
    @Index(name = "sfa_help_defense_plan_detail_exception_index1", columnList = "help_plan_detail_id", unique = true),
})
@ApiModel(value = "HelpDefensePlanDetailException", description = "协访计划明细异常表")
@org.hibernate.annotations.Table(appliesTo = "sfa_help_defense_plan_detail_exception", comment = "协访计划明细异常表")
public class HelpDefensePlanDetailException extends UuidOpEntity {

  private static final long serialVersionUID = 7022214277071025864L;

  /**
   * 协访计划明细id
   */
  @ApiModelProperty("协访计划明细id")
  @Column(name = "help_plan_detail_id", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '协访计划明细id'")
  private String helpPlanDetailId;

  /**
   * 异常信息
   */
  @ApiModelProperty("异常信息")
  @Column(name = "remark", length = 255, nullable = false, columnDefinition = "varchar(255) COMMENT '异常信息'")
  private String remark;

  /**
   * 图片
   */
  @ApiModelProperty("图片")
  @Transient
  @TableField(exist = false)
  private List<HelpDefensePlanDetailExceptionFile> pictureList;


}
