package com.biz.crm.sfa.business.help.defense.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.help.defense.local.entity.HelpDefense;
import com.biz.crm.sfa.business.help.defense.sdk.dto.HelpDefenseQueryDto;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 协访计划制定表(HelpDefense)表mybatis访问层
 *
 * @author songjingen
 * @since 2022-05-19 11:21:58
 */
public interface HelpDefenseMapper extends BaseMapper<HelpDefense> {

  /**
   * 分页查询所有数据
   *
   * @param page 分页对象
   * @param dto  查询实体
   * @return 所有数据
   */
  public Page<HelpDefense> findByConditions(@Param("page") Page<HelpDefense> page, @Param("dto") HelpDefenseQueryDto dto);

  /**
   * 根据协防人集合、被协防人集合、协防时间集合查询数据
   *
   * @param userNames
   * @param covertUserNames
   * @param helpDates
   * @return
   */
  List<HelpDefense> findByHelpUserNamesAndCovertUserNamesAndHelpDates(@Param("userNames") Set<String> userNames, @Param("covertUserNames") Set<String> covertUserNames, @Param("helpDates") Set<Date> helpDates);
}

