package com.biz.crm.sfa.business.help.defense.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.help.defense.local.entity.HelpDefenseClientInfo;
import com.biz.crm.sfa.business.help.defense.local.mapper.HelpDefenseClientInfoMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 协访计划客户信息表(HelpDefenseClientInfo)表数据库访问层
 *
 * @author songjingen
 * @since 2022-05-19 11:21:58
 */
@Component
public class HelpDefenseClientInfoRepository extends ServiceImpl<HelpDefenseClientInfoMapper, HelpDefenseClientInfo> {

  /**
   * 根据协访计划编码删除数据
   *
   * @param helpPlanCodes
   */
  public void deleteByHelpPlanCode(List<String> helpPlanCodes) {
    this.lambdaUpdate().in(HelpDefenseClientInfo::getHelpPlanCode, helpPlanCodes).remove();
  }

  /**
   * 根据协访计划编码查询数据
   *
   * @param helpPlanCode
   * @return
   */
  public List<HelpDefenseClientInfo> findByHelpPlanCodes(String helpPlanCode) {
    return this.lambdaQuery().eq(HelpDefenseClientInfo::getHelpPlanCode, helpPlanCode).list();
  }
}

