package com.biz.crm.sfa.business.help.defense.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.help.defense.local.entity.HelpDefensePlanDetailExceptionFile;
import com.biz.crm.sfa.business.help.defense.local.mapper.HelpDefensePlanDetailExceptionFileMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 协访计划明细异常文件表(HelpDefensePlanDetailExceptionFile)表数据库访问层
 *
 * @author songjingen
 * @since 2022-06-28 20:08:22
 */
@Component
public class HelpDefensePlanDetailExceptionFileRepository extends ServiceImpl<HelpDefensePlanDetailExceptionFileMapper, HelpDefensePlanDetailExceptionFile> {

  /**
   * 根据协防计划主键查询数据
   *
   * @param exceptionIds
   * @return
   */
  public List<HelpDefensePlanDetailExceptionFile> findByExceptionIds(List<String> exceptionIds) {
    return this.lambdaQuery().in(HelpDefensePlanDetailExceptionFile::getHelpPlanDetailExceptionId, exceptionIds).list();
  }
}

