package com.biz.crm.sfa.business.help.defense.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.help.defense.local.entity.HelpDefensePlanDetailException;
import com.biz.crm.sfa.business.help.defense.local.mapper.HelpDefensePlanDetailExceptionMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 协访计划明细异常表(HelpDefensePlanDetailException)表数据库访问层
 *
 * @author songjingen
 * @since 2022-06-28 20:08:22
 */
@Component
public class HelpDefensePlanDetailExceptionRepository extends ServiceImpl<HelpDefensePlanDetailExceptionMapper, HelpDefensePlanDetailException> {

  /**
   * 根据计划明细主键查询数据
   *
   * @param helpPlanDetailId
   * @return
   */
  public List<HelpDefensePlanDetailException> findByHelpPlanDetailId(String helpPlanDetailId) {
    return this.lambdaQuery().eq(HelpDefensePlanDetailException::getHelpPlanDetailId, helpPlanDetailId).list();
  }
}

