package com.biz.crm.sfa.business.help.defense.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.help.defense.local.entity.HelpDefensePlanDetail;
import com.biz.crm.sfa.business.help.defense.local.mapper.HelpDefensePlanDetailMapper;
import com.biz.crm.sfa.business.help.defense.sdk.dto.HelpDefensePlanDetailPageDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 协访计划明细表(HelpDefensePlanDetail)表数据库访问层
 *
 * @author songjingen
 * @since 2022-06-07 15:43:22
 */
@Component
public class HelpDefensePlanDetailRepository extends ServiceImpl<HelpDefensePlanDetailMapper, HelpDefensePlanDetail> {

  @Autowired
  private HelpDefensePlanDetailMapper helpDefensePlanDetailMapper;

  /**
   * 分页查询数据
   *
   * @param pageable 分页对象
   * @param dto      实体对象
   * @return
   */
  public Page<HelpDefensePlanDetail> findByConditions(Pageable pageable, HelpDefensePlanDetailPageDto dto) {
    Page<HelpDefensePlanDetail> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<HelpDefensePlanDetail> pageList = this.helpDefensePlanDetailMapper.findByConditions(page, dto);
    return pageList;
  }

  /**
   * 根据id更改协访状态
   *
   * @param id
   * @param helpStatus
   */
  public void updateHelpStatusById(String helpStatus, String id) {
    this.lambdaUpdate().set(HelpDefensePlanDetail::getHelpStatus, helpStatus)
        .eq(HelpDefensePlanDetail::getId, id)
        .update();
  }

  /**
   * 根据用户账号查看数据
   *
   * @param userName
   * @param visitDate
   * @return
   */
  public List<HelpDefensePlanDetail> findByUserNameAndVisitDate(String userName, Date visitDate) {
    return this.baseMapper.findByUserNameAndVisitDate(userName, visitDate);
  }

  /**
   * 查询 状态、时间、租户查询用户账号集合
   *
   * @param helpStatus
   * @param helpDate
   * @return
   */
  public Set<String> findUserNamesByHelpStatusAndHelpDate(String helpStatus, Date helpDate) {
    return this.baseMapper.findUserNamesByHelpStatusAndHelpDate(helpStatus, helpDate);
  }


  /**
   * 根据状态和时间查询数据
   *
   * @param helpDate
   * @param helpStatus
   * @return
   */
  public List<HelpDefensePlanDetail> findByHelpStatusAndHelpDate(String helpStatus, Date helpDate) {
    return this.lambdaQuery().eq(HelpDefensePlanDetail::getHelpStatus, helpStatus)
        .eq(HelpDefensePlanDetail::getHelpDate, helpDate)
        .list();
  }

  /**
   * 根据计划编码查询数据
   *
   * @param planCodes
   * @return
   */
  public List<HelpDefensePlanDetail> findByPlanCodes(Set<String> planCodes) {
    return this.lambdaQuery().in(HelpDefensePlanDetail::getHelpPlanCode, planCodes).list();
  }
}

