package com.biz.crm.sfa.business.help.defense.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.sfa.business.help.defense.local.entity.HelpDefense;
import com.biz.crm.sfa.business.help.defense.local.mapper.HelpDefenseMapper;
import com.biz.crm.sfa.business.help.defense.sdk.dto.HelpDefenseQueryDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 协访计划制定表(HelpDefense)表数据库访问层
 *
 * @author songjingen
 * @since 2022-05-19 11:21:57
 */
@Component
public class HelpDefenseRepository extends ServiceImpl<HelpDefenseMapper, HelpDefense> {

  @Autowired
  private HelpDefenseMapper helpDefenseMapper;

  /**
   * 分页查询数据
   *
   * @param pageable    分页对象
   * @param helpDefense 实体对象
   * @return
   */
  public Page<HelpDefense> findByConditions(Pageable pageable, HelpDefenseQueryDto helpDefense) {
    Page<HelpDefense> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<HelpDefense> pageList = this.helpDefenseMapper.findByConditions(page, helpDefense);
    return pageList;
  }

  /**
   * 根据id集合更新启禁用装填
   *
   * @param ids          分页对象
   * @param enableStatus 启禁用状态对象
   * @return
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enableStatus) {
    this.lambdaUpdate()
        .in(HelpDefense::getId, ids)
        .set(HelpDefense::getEnableStatus, enableStatus.getCode())
        .update();
  }

  /**
   * 根据协访人账号，被协访人账号，协访时间，租户查询数据
   *
   * @param tenantCode
   * @param helpUserName
   * @param coverHelpUserName
   * @param helpDefenseDate
   * @return
   */
  public HelpDefense findByUserNameAndHelpDefenseDate(String tenantCode, String helpUserName, String coverHelpUserName, Date helpDefenseDate) {
    return this.lambdaQuery().eq(HelpDefense::getTenantCode, tenantCode)
        .eq(HelpDefense::getHelpUserName, helpUserName)
        .eq(HelpDefense::getCoverHelpUserName, coverHelpUserName)
        .eq(HelpDefense::getHelpDefenseDate, helpDefenseDate)
        .eq(HelpDefense::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .eq(HelpDefense::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
        .one();
  }

  /**
   * 根据协访人账号和协访时间删除数据
   *
   * @param helpDefenseDate
   * @param helpUserName
   * @param delete
   */
  public void updateDelFlagByHelpDefenseDateAndHelpUserName(Date helpDefenseDate, String helpUserName, DelFlagStatusEnum delete) {
    this.lambdaUpdate().set(HelpDefense::getDelFlag, delete.getCode())
        .eq(HelpDefense::getHelpUserName, helpUserName)
        .eq(HelpDefense::getHelpDefenseDate, helpDefenseDate)
        .update();

  }

  /**
   * 根据planCode查询协访计划
   *
   * @param planCode
   * @return
   */
  public HelpDefense findByPlanCode(String planCode) {
    return this.lambdaQuery().eq(HelpDefense::getHelpPlanCode, planCode)
        .one();
  }

  /**
   * 根据协防人集合、被协防人集合、协防时间集合查询数据
   *
   * @param userNames
   * @param covertUserNames
   * @param helpDates
   * @return
   */
  public List<HelpDefense> findByHelpUserNamesAndCovertUserNamesAndHelpDates(Set<String> userNames, Set<String> covertUserNames, Set<Date> helpDates) {
    return this.helpDefenseMapper.findByHelpUserNamesAndCovertUserNamesAndHelpDates(userNames, covertUserNames, helpDates);
  }

  /**
   * 根据计划编码集合查看数据
   */
  public List<HelpDefense> findByPlanCodes(Set<String> planCodes) {
    return this.lambdaQuery().in(HelpDefense::getHelpPlanCode, planCodes).list();
  }

  /**
   * 根据id集合查询数据
   *
   * @param idList
   * @return
   */
  public List<HelpDefense> findByIds(List<String> idList) {
    return this.lambdaQuery().eq(HelpDefense::getDelFlag, DelFlagStatusEnum.NORMAL.getCode()).in(HelpDefense::getId, idList).list();
  }
}

