package com.biz.crm.sfa.business.help.defense.local.service;


import com.biz.crm.sfa.business.help.defense.local.entity.HelpDefensePlanDetail;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 协访计划明细表(HelpDefensePlanDetail)表服务接口
 *
 * @author songjingen
 * @since 2022-06-07 15:43:21
 */
public interface HelpDefensePlanDetailService {

  /**
   * 新增数据批量
   *
   * @param helpDefensePlanDetails 实体对象
   * @return 新增结果
   */
  void createBatch(List<HelpDefensePlanDetail> helpDefensePlanDetails);

  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);

  /**
   * 查看完成进度
   *
   * @param userName
   * @param visitDate
   * @return {"completed":"已完成数量","total":"总数量"}
   */
  Map<String, Integer> findScheduleByUserNameAndVisitDate(String userName, Date visitDate);

  /**
   * 根据协防人账号和协防时间查询数据
   *
   * @param helpUserName
   * @param helpDefenseDate
   * @return
   */
  List<HelpDefensePlanDetail> findByHelpUserNameAndHelpDate(String helpUserName, Date helpDefenseDate);

  /**
   * 执行任务，每天零时5分结束前一天的拜访中任务
   */
  void executeTask();

  /**
   * 根基计划编码查询数据
   *
   * @param planCodes
   * @return
   */
  List<HelpDefensePlanDetail> findByPlanCodes(Set<String> planCodes);
}

