package com.biz.crm.sfa.business.help.defense.local.service.internal;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import com.biz.crm.sfa.business.client.sdk.strategy.ClientRouteStrategy;
import com.biz.crm.sfa.business.client.sdk.vo.ClientRouteInfoVo;
import com.biz.crm.sfa.business.help.defense.local.entity.HelpDefensePlanDetail;
import com.biz.crm.sfa.business.help.defense.local.repository.HelpDefensePlanDetailRepository;
import com.biz.crm.sfa.business.help.defense.sdk.dto.HelpDefensePlanDetailPageDto;
import com.biz.crm.sfa.business.help.defense.sdk.service.HelpDefensePlanDetailVoService;
import com.biz.crm.sfa.business.help.defense.sdk.vo.HelpDefensePlanDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 协访计划明细voService实现类
 *
 * @author songjingen
 */
@Service
public class HelpDefensePlanDetailVoServiceImpl implements HelpDefensePlanDetailVoService {

  @Autowired
  private HelpDefensePlanDetailRepository helpDefensePlanDetailRepository;

  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Autowired
  private List<ClientRouteStrategy> clientRouteStrategies;

  @Override
  public Page<HelpDefensePlanDetailVo> findByConditions(Pageable pageable, HelpDefensePlanDetailPageDto dto) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (dto == null) {
      dto = new HelpDefensePlanDetailPageDto();
    }
    dto.setTenantCode(TenantUtils.getTenantCode());
    Page<HelpDefensePlanDetail> page = this.helpDefensePlanDetailRepository.findByConditions(pageable, dto);
    List<HelpDefensePlanDetail> records = page.getRecords();
    if (CollectionUtils.isEmpty(records)) {
      return new Page<>();
    }
    List<HelpDefensePlanDetailVo> helpDefensePlanDetailVos = this.buildHelpDefensePlanDetailVos(records);
    Page<HelpDefensePlanDetailVo> voPage = new Page<>();
    BeanUtils.copyProperties(page, voPage);
    voPage.setRecords(helpDefensePlanDetailVos);
    return voPage;
  }

  @Override
  public HelpDefensePlanDetailVo findById(String id) {
    HelpDefensePlanDetail helpDefensePlanDetail = this.helpDefensePlanDetailRepository.getById(id);
    return this.nebulaToolkitService.copyObjectByWhiteList(helpDefensePlanDetail, HelpDefensePlanDetailVo.class, HashSet.class, ArrayList.class);
  }

  /**
   * 组装VisitPlanDetailVo集合信息
   *
   * @param records
   */
  private List<HelpDefensePlanDetailVo> buildHelpDefensePlanDetailVos(List<HelpDefensePlanDetail> records) {
    //Map<clientRoute, Map<clientType, List<clientCode>>>
    Map<String, Map<String, List<String>>> clientMap = records.stream()
        .collect(
            Collectors.groupingBy(HelpDefensePlanDetail::getClientRoute,
                Collectors.groupingBy(HelpDefensePlanDetail::getClientType, Collectors.mapping(HelpDefensePlanDetail::getClientCode, Collectors.toList())
                )));
    //判断客户维度策略
    Map<String, List<ClientRouteInfoVo>> infoVoHashMap = new HashMap<>();
    if (!CollectionUtils.isEmpty(clientRouteStrategies)) {
      List<ClientRouteInfoVo> infoVos = new ArrayList<>();
      for (ClientRouteStrategy clientRouteStrategy : clientRouteStrategies) {
        Map<String, List<String>> listMap = clientMap.get(clientRouteStrategy.getKey());
        if (listMap != null) {
          List<ClientRouteInfoVo> terminalVos = clientRouteStrategy.onFindByClientCodesAndType(listMap.get(ClientTypeEnum.TERMINAL.getDictCode()), ClientTypeEnum.TERMINAL.getDictCode());
          List<ClientRouteInfoVo> dealerVos = clientRouteStrategy.onFindByClientCodesAndType(listMap.get(ClientTypeEnum.DEALER.getDictCode()), ClientTypeEnum.DEALER.getDictCode());
          infoVos.addAll(terminalVos);
          infoVos.addAll(dealerVos);
        }
      }
      if (!CollectionUtils.isEmpty(infoVos)) {
        infoVoHashMap = infoVos.stream().collect(Collectors.groupingBy(o -> StringUtils.joinWith("_", o.getClientRoute(), o.getClientType(), o.getClientCode())));
      }
    }

    ArrayList<HelpDefensePlanDetailVo> helpDefensePlanDetailVos = new ArrayList<>();
    for (HelpDefensePlanDetail defensePlanDetail : records) {
      HelpDefensePlanDetailVo helpDefensePlanDetailVo = this.nebulaToolkitService.copyObjectByWhiteList(defensePlanDetail, HelpDefensePlanDetailVo.class, HashSet.class, ArrayList.class);
      String key = StringUtils.joinWith("_", helpDefensePlanDetailVo.getClientRoute(), helpDefensePlanDetailVo.getClientType(), helpDefensePlanDetailVo.getClientCode());
      List<ClientRouteInfoVo> vos = infoVoHashMap.get(key);
      if (!CollectionUtils.isEmpty(vos)) {
        ClientRouteInfoVo vo = vos.get(0);
        BeanUtil.copyProperties(vo, helpDefensePlanDetailVo);
      }
      helpDefensePlanDetailVos.add(helpDefensePlanDetailVo);
    }
    return helpDefensePlanDetailVos;
  }
}
