package com.biz.crm.sfa.business.help.defense.local.service.internal;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.sfa.business.help.defense.local.entity.HelpDefense;
import com.biz.crm.sfa.business.help.defense.local.entity.HelpDefenseClientInfo;
import com.biz.crm.sfa.business.help.defense.local.repository.HelpDefenseClientInfoRepository;
import com.biz.crm.sfa.business.help.defense.local.repository.HelpDefenseRepository;
import com.biz.crm.sfa.business.help.defense.sdk.dto.HelpDefenseQueryDto;
import com.biz.crm.sfa.business.help.defense.sdk.service.HelpDefenseVoService;
import com.biz.crm.sfa.business.help.defense.sdk.vo.HelpDefenseClientInfoVo;
import com.biz.crm.sfa.business.help.defense.sdk.vo.HelpDefenseVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 协访计划制定表(HelpDefense)表服务实现类
 *
 * @author songjingen
 * @since 2022-05-19 11:21:57
 */
@Service
public class HelpDefenseVoServiceImpl implements HelpDefenseVoService {

  @Autowired
  private HelpDefenseRepository helpDefenseRepository;

  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Autowired
  private HelpDefenseClientInfoRepository helpDefenseClientInfoRepository;

  @Autowired
  private UserFeignVoService userFeignVoService;

  /**
   * 分页查询数据
   *
   * @param pageable 分页对象
   * @param dto      实体对象
   * @return
   */
  @Override
  public Page<HelpDefenseVo> findByConditions(Pageable pageable, HelpDefenseQueryDto dto) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (Objects.isNull(dto)) {
      dto = new HelpDefenseQueryDto();
    }
    dto.setTenantCode(TenantUtils.getTenantCode());
    Page<HelpDefense> page = this.helpDefenseRepository.findByConditions(pageable, dto);
    List<HelpDefense> records = page.getRecords();
    if (CollectionUtils.isEmpty(records)) {
      return new Page<>();
    }
    Page<HelpDefenseVo> voPage = new Page<>();
    BeanUtils.copyProperties(page, voPage);
    List<HelpDefenseVo> helpDefenseVos = (List<HelpDefenseVo>) this.nebulaToolkitService.copyCollectionByWhiteList(records, HelpDefense.class, HelpDefenseVo.class, HashSet.class, ArrayList.class);
    this.buildHelpDefenseVo(helpDefenseVos);
    voPage.setRecords(helpDefenseVos);
    return voPage;
  }

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @Override
  public HelpDefenseVo findById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    HelpDefense helpDefense = this.helpDefenseRepository.getById(id);
    if (helpDefense == null) {
      return null;
    }
    HelpDefenseVo helpDefenseVo = this.nebulaToolkitService.copyObjectByBlankList(helpDefense, HelpDefenseVo.class, HashSet.class, ArrayList.class);
    this.buildHelpDefenseVo(Lists.newArrayList(helpDefenseVo));
    List<HelpDefenseClientInfo> clientInfos = this.helpDefenseClientInfoRepository.findByHelpPlanCodes(helpDefense.getHelpPlanCode());
    if (!CollectionUtils.isEmpty(clientInfos)) {
      List<HelpDefenseClientInfoVo> helpDefenseClientInfoVos = (List<HelpDefenseClientInfoVo>) this.nebulaToolkitService.copyCollectionByWhiteList(clientInfos, HelpDefenseClientInfo.class, HelpDefenseClientInfoVo.class, HashSet.class, ArrayList.class);
      helpDefenseVo.setClientInfoVos(helpDefenseClientInfoVos);
    }
    return helpDefenseVo;
  }

  @Override
  public HelpDefenseVo findByPlanCode(String code) {
    if (StringUtils.isBlank(code)) {
      return null;
    }
    HelpDefense helpDefense = this.helpDefenseRepository.findByPlanCode(code);
    if (helpDefense == null) {
      return null;
    }
    HelpDefenseVo helpDefenseVo = this.nebulaToolkitService.copyObjectByBlankList(helpDefense, HelpDefenseVo.class, HashSet.class, ArrayList.class);
    this.buildHelpDefenseVo(Lists.newArrayList(helpDefenseVo));
    List<HelpDefenseClientInfo> clientInfos = this.helpDefenseClientInfoRepository.findByHelpPlanCodes(helpDefense.getHelpPlanCode());
    if (!CollectionUtils.isEmpty(clientInfos)) {
      List<HelpDefenseClientInfoVo> helpDefenseClientInfoVos = (List<HelpDefenseClientInfoVo>) this.nebulaToolkitService.copyCollectionByWhiteList(clientInfos, HelpDefenseClientInfo.class, HelpDefenseClientInfoVo.class, HashSet.class, ArrayList.class);
      helpDefenseVo.setClientInfoVos(helpDefenseClientInfoVos);
    }
    return helpDefenseVo;
  }

  /**
   * 组装协访vo信息
   *
   * @param helpDefenseVos
   */
  private void buildHelpDefenseVo(List<HelpDefenseVo> helpDefenseVos) {
    if (CollectionUtils.isEmpty(helpDefenseVos)) {
      return;
    }
    Set<String> userNames = new HashSet<>();
    helpDefenseVos.stream().forEach(helpDefenseVo -> {
      userNames.add(helpDefenseVo.getHelpUserName());
      userNames.add(helpDefenseVo.getCoverHelpUserName());
    });
    List<UserVo> userVoList = this.userFeignVoService.findByUserNames(Lists.newArrayList(userNames));
    if (CollectionUtils.isEmpty(userVoList)) {
      return;
    }
    Map<String, UserVo> userVoMap = userVoList.stream().filter(userVo -> StringUtils.isNotBlank(userVo.getUserName())).collect(Collectors.toMap(UserVo::getUserName, a -> a));
    helpDefenseVos.stream().forEach(helpDefenseVo -> {
      UserVo userVo = userVoMap.get(helpDefenseVo.getHelpUserName());
      if (userVo != null) {
        helpDefenseVo.setHelpPostCode(userVo.getPositionCode());
        helpDefenseVo.setHelpPostName(userVo.getPositionName());
        helpDefenseVo.setHelpOrgCode(userVo.getOrgCode());
        helpDefenseVo.setHelpOrgName(userVo.getOrgName());
      }
    });
  }

}

