/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.help.defense.local.controller;

import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.help.defense.local.service.HelpDefensePlanDetailService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/helpDefense/helpDefensePlanDetail"})
@Api(tags={"\u534f\u8bbf\u7ba1\u7406\uff1aHelpDefensePlanDetail\uff1a\u534f\u8bbf\u8ba1\u5212\u660e\u7ec6\u8868"})
public class HelpDefensePlanDetailController {
    private static final Logger log = LoggerFactory.getLogger(HelpDefensePlanDetailController.class);
    @Autowired
    private HelpDefensePlanDetailService helpDefensePlanDetailService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @DeleteMapping
    @ApiOperation(value="\u5220\u9664\u6570\u636e\uff08\u5355\u4e2a\u6216\u8005\u6279\u91cf\uff09")
    public Result<?> delete(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestParam(value="ids") List<String> ids) {
        try {
            this.helpDefensePlanDetailService.delete(ids);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u770b\u8fdb\u5ea6\u63a5\u53e3")
    @GetMapping(value={"findScheduleByCurrentUserAndVisitDate"})
    public Result<?> findScheduleByCurrentUserAndVisitDate(@ApiParam(name="visitDate", value="\u62dc\u8bbf\u65e5\u671f") @RequestParam(value="visitDate") @DateTimeFormat(pattern="yyyy-MM-dd") Date visitDate) {
        try {
            LoginUserDetails loginDetails = (LoginUserDetails)this.loginUserService.getLoginDetails(LoginUserDetails.class);
            Map<String, Integer> map = this.helpDefensePlanDetailService.findScheduleByUserNameAndVisitDate(loginDetails.getAccount(), visitDate);
            return Result.ok(map);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6267\u884c\u4efb\u52a1\uff0c\u6bcf\u5929\u96f6\u65f65\u5206\u7ed3\u675f\u524d\u4e00\u5929\u7684\u534f\u8bbf\u4e2d\u4efb\u52a1")
    @PostMapping(value={"executeTask"})
    public Result<?> executeTask() {
        try {
            this.helpDefensePlanDetailService.executeTask();
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

