/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.help.defense.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.sfa.business.help.defense.local.entity.HelpDefense;
import com.biz.crm.sfa.business.help.defense.local.mapper.HelpDefenseMapper;
import com.biz.crm.sfa.business.help.defense.sdk.dto.HelpDefenseQueryDto;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class HelpDefenseRepository
extends ServiceImpl<HelpDefenseMapper, HelpDefense> {
    @Autowired
    private HelpDefenseMapper helpDefenseMapper;

    public Page<HelpDefense> findByConditions(Pageable pageable, HelpDefenseQueryDto helpDefense) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<HelpDefense> pageList = this.helpDefenseMapper.findByConditions((Page<HelpDefense>)page, helpDefense);
        return pageList;
    }

    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enableStatus) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)enableStatus.getCode())).update();
    }

    public HelpDefense findByUserNameAndHelpDefenseDate(String tenantCode, String helpUserName, String coverHelpUserName, Date helpDefenseDate) {
        return (HelpDefense)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(HelpDefense::getHelpUserName, (Object)helpUserName)).eq(HelpDefense::getCoverHelpUserName, (Object)coverHelpUserName)).eq(HelpDefense::getHelpDefenseDate, (Object)helpDefenseDate)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).one());
    }

    public void updateDelFlagByHelpDefenseDateAndHelpUserName(Date helpDefenseDate, String helpUserName, DelFlagStatusEnum delete) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(UuidFlagOpEntity::getDelFlag, (Object)delete.getCode())).eq(HelpDefense::getHelpUserName, (Object)helpUserName)).eq(HelpDefense::getHelpDefenseDate, (Object)helpDefenseDate)).update();
    }

    public HelpDefense findByPlanCode(String planCode) {
        return (HelpDefense)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(HelpDefense::getHelpPlanCode, (Object)planCode)).one());
    }

    public List<HelpDefense> findByHelpUserNamesAndCovertUserNamesAndHelpDates(Set<String> userNames, Set<String> covertUserNames, Set<Date> helpDates) {
        return this.helpDefenseMapper.findByHelpUserNamesAndCovertUserNamesAndHelpDates(userNames, covertUserNames, helpDates);
    }

    public List<HelpDefense> findByPlanCodes(Set<String> planCodes) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(HelpDefense::getHelpPlanCode, planCodes)).list();
    }

    public List<HelpDefense> findByIds(List<String> idList) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(UuidEntity::getId, idList)).list();
    }
}

