/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.help.defense.local.service.internal;

import com.biz.crm.sfa.business.help.defense.local.entity.HelpDefensePlanDetailException;
import com.biz.crm.sfa.business.help.defense.local.entity.HelpDefensePlanDetailExceptionFile;
import com.biz.crm.sfa.business.help.defense.local.repository.HelpDefensePlanDetailExceptionRepository;
import com.biz.crm.sfa.business.help.defense.local.repository.HelpDefensePlanDetailRepository;
import com.biz.crm.sfa.business.help.defense.local.service.HelpDefensePlanDetailExceptionFileService;
import com.biz.crm.sfa.business.help.defense.local.service.HelpDefensePlanDetailExceptionService;
import com.biz.crm.sfa.business.help.defense.sdk.enums.HelpStatusEnum;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="helpDefensePlanDetailExceptionService")
public class HelpDefensePlanDetailExceptionServiceImpl
implements HelpDefensePlanDetailExceptionService {
    @Autowired
    private HelpDefensePlanDetailExceptionRepository helpDefensePlanDetailExceptionRepository;
    @Autowired
    private HelpDefensePlanDetailExceptionFileService helpDefensePlanDetailExceptionFileService;
    @Autowired
    private HelpDefensePlanDetailRepository helpDefensePlanDetailRepository;

    @Override
    @Transactional
    public HelpDefensePlanDetailException create(HelpDefensePlanDetailException helpDefensePlanDetailException) {
        this.createValidate(helpDefensePlanDetailException);
        this.helpDefensePlanDetailExceptionRepository.saveOrUpdate((Object)helpDefensePlanDetailException);
        List<HelpDefensePlanDetailExceptionFile> pictureList = helpDefensePlanDetailException.getPictureList();
        if (!CollectionUtils.isEmpty(pictureList)) {
            pictureList.forEach(helpDefensePlanDetailExceptionFile -> helpDefensePlanDetailExceptionFile.setHelpPlanDetailExceptionId(helpDefensePlanDetailException.getId()));
            this.helpDefensePlanDetailExceptionFileService.createBatch(pictureList);
        }
        this.helpDefensePlanDetailRepository.updateHelpStatusById(HelpStatusEnum.EXCEPTION.getDictCode(), helpDefensePlanDetailException.getHelpPlanDetailId());
        return helpDefensePlanDetailException;
    }

    @Override
    public HelpDefensePlanDetailException findByHelpPlanDetailId(String helpPlanDetailId) {
        if (StringUtils.isBlank((CharSequence)helpPlanDetailId)) {
            return null;
        }
        List<HelpDefensePlanDetailException> helpDefensePlanDetailExceptions = this.helpDefensePlanDetailExceptionRepository.findByHelpPlanDetailId(helpPlanDetailId);
        if (CollectionUtils.isEmpty(helpDefensePlanDetailExceptions)) {
            return null;
        }
        HelpDefensePlanDetailException helpDefensePlanDetailException = helpDefensePlanDetailExceptions.get(0);
        List<HelpDefensePlanDetailExceptionFile> files = this.helpDefensePlanDetailExceptionFileService.findByExceptionIds(Lists.newArrayList((Object[])new String[]{helpDefensePlanDetailException.getId()}));
        helpDefensePlanDetailException.setPictureList(files);
        return helpDefensePlanDetailException;
    }

    @Override
    @Transactional
    public void createBatch(List<HelpDefensePlanDetailException> exceptions) {
        Validate.isTrue((!CollectionUtils.isEmpty(exceptions) ? 1 : 0) != 0, (String)"\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        exceptions.forEach(this::createValidate);
        this.helpDefensePlanDetailExceptionRepository.saveBatch(exceptions);
    }

    private void createValidate(HelpDefensePlanDetailException helpDefensePlanDetailException) {
        Validate.notNull((Object)((Object)helpDefensePlanDetailException), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        helpDefensePlanDetailException.setId(null);
        Validate.notBlank((CharSequence)helpDefensePlanDetailException.getHelpPlanDetailId(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u534f\u8bbf\u8ba1\u5212\u660e\u7ec6id\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)helpDefensePlanDetailException.getRemark(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5f02\u5e38\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<HelpDefensePlanDetailException> exceptions = this.helpDefensePlanDetailExceptionRepository.findByHelpPlanDetailId(helpDefensePlanDetailException.getHelpPlanDetailId());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(exceptions), (String)"\u5f53\u524d\u8ba1\u5212\u5df2\u63d0\u62a5\u5f02\u5e38\uff01", (Object[])new Object[0]);
    }
}

