/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.help.defense.local.service.internal;

import com.biz.crm.sfa.business.help.defense.local.entity.HelpDefensePlanDetailPerformance;
import com.biz.crm.sfa.business.help.defense.local.repository.HelpDefensePlanDetailPerformanceRepository;
import com.biz.crm.sfa.business.help.defense.local.service.HelpDefensePlanDetailPerformanceService;
import com.biz.crm.sfa.business.step.sdk.service.StepFormVoService;
import com.biz.crm.sfa.business.step.sdk.vo.StepFormVo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="helpDefensePlanDetailPerformanceService")
public class HelpDefensePlanDetailPerformanceServiceImpl
implements HelpDefensePlanDetailPerformanceService {
    @Autowired
    private HelpDefensePlanDetailPerformanceRepository helpDefensePlanDetailPerformanceRepository;
    @Autowired(required=false)
    private StepFormVoService stepFormVoService;

    @Override
    @Transactional
    public HelpDefensePlanDetailPerformance create(HelpDefensePlanDetailPerformance helpDefensePlanDetailPerformance) {
        this.createValidate(helpDefensePlanDetailPerformance);
        this.helpDefensePlanDetailPerformanceRepository.saveOrUpdate((Object)helpDefensePlanDetailPerformance);
        return helpDefensePlanDetailPerformance;
    }

    @Override
    public List<HelpDefensePlanDetailPerformance> findByDetailId(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return new ArrayList<HelpDefensePlanDetailPerformance>();
        }
        List<HelpDefensePlanDetailPerformance> detailPerformances = this.helpDefensePlanDetailPerformanceRepository.findByDetailId(id);
        if (CollectionUtils.isEmpty(detailPerformances)) {
            return new ArrayList<HelpDefensePlanDetailPerformance>(0);
        }
        Set stepCodes = detailPerformances.stream().map(HelpDefensePlanDetailPerformance::getStepCode).collect(Collectors.toSet());
        List stepFormVos = this.stepFormVoService.findByStepCodes(stepCodes);
        if (CollectionUtils.isEmpty(stepCodes)) {
            return new ArrayList<HelpDefensePlanDetailPerformance>(0);
        }
        Map<String, StepFormVo> stepFormVoMap = stepFormVos.stream().collect(Collectors.toMap(StepFormVo::getStepCode, o -> o));
        for (HelpDefensePlanDetailPerformance performance : detailPerformances) {
            StepFormVo stepFormVo = stepFormVoMap.get(performance.getStepCode());
            if (stepFormVo == null) continue;
            performance.setStepName(stepFormVo.getStepName());
        }
        return detailPerformances;
    }

    private void createValidate(HelpDefensePlanDetailPerformance helpDefensePlanDetailPerformance) {
        Validate.notNull((Object)((Object)helpDefensePlanDetailPerformance), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        helpDefensePlanDetailPerformance.setId(null);
        Validate.notBlank((CharSequence)helpDefensePlanDetailPerformance.getHelpDefensePlanDetailId(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u534f\u8bbf\u8ba1\u5212\u660e\u7ec6id\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)helpDefensePlanDetailPerformance.getStepCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6b65\u9aa4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

