/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.help.defense.local.service.internal;

import com.biz.crm.sfa.business.help.defense.local.entity.HelpDefensePlanDetail;
import com.biz.crm.sfa.business.help.defense.local.entity.HelpDefensePlanDetailException;
import com.biz.crm.sfa.business.help.defense.local.repository.HelpDefensePlanDetailRepository;
import com.biz.crm.sfa.business.help.defense.local.service.HelpDefensePlanDetailExceptionService;
import com.biz.crm.sfa.business.help.defense.local.service.HelpDefensePlanDetailService;
import com.biz.crm.sfa.business.help.defense.sdk.enums.HelpStatusEnum;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="helpDefensePlanDetailService")
public class HelpDefensePlanDetailServiceImpl
implements HelpDefensePlanDetailService {
    @Autowired
    private HelpDefensePlanDetailRepository helpDefensePlanDetailRepository;
    @Autowired
    private HelpDefensePlanDetailExceptionService helpDefensePlanDetailExceptionService;

    @Override
    @Transactional
    public void createBatch(List<HelpDefensePlanDetail> helpDefensePlanDetails) {
        Validate.isTrue((!CollectionUtils.isEmpty(helpDefensePlanDetails) ? 1 : 0) != 0, (String)"\u6279\u91cf\u65b0\u589e\u534f\u8bbf\u8ba1\u5212\u660e\u7ec6\u65f6\uff0c\u5165\u53c2\u96c6\u5408\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        helpDefensePlanDetails.forEach(this::createValidate);
        this.helpDefensePlanDetailRepository.saveBatch(helpDefensePlanDetails);
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.helpDefensePlanDetailRepository.removeByIds(idList);
    }

    @Override
    public Map<String, Integer> findScheduleByUserNameAndVisitDate(String userName, Date visitDate) {
        if (StringUtils.isBlank((CharSequence)userName) || visitDate == null) {
            return new HashMap<String, Integer>(0);
        }
        List<HelpDefensePlanDetail> totalList = this.helpDefensePlanDetailRepository.findByUserNameAndVisitDate(userName, visitDate);
        if (CollectionUtils.isEmpty(totalList)) {
            return new HashMap<String, Integer>(0);
        }
        List completedList = totalList.stream().filter(visitPlanDetail -> HelpStatusEnum.COMPLETE.getDictCode().equals(visitPlanDetail.getHelpStatus())).collect(Collectors.toList());
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(2);
        hashMap.put("completed", CollectionUtils.isEmpty(completedList) ? 0 : completedList.size());
        hashMap.put("total", totalList.size());
        return hashMap;
    }

    @Override
    public List<HelpDefensePlanDetail> findByHelpUserNameAndHelpDate(String helpUserName, Date helpDefenseDate) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{helpUserName}) || helpDefenseDate == null) {
            return null;
        }
        return this.helpDefensePlanDetailRepository.findByUserNameAndVisitDate(helpUserName, helpDefenseDate);
    }

    @Override
    @Transactional
    @DynamicTaskService(cornExpression="0 5 0 * * ?", taskDesc="\u534f\u8bbf\u8ba1\u5212\u5b9a\u65f6\u4efb\u52a1")
    public void executeTask() {
        try {
            Date before = DateUtils.addDays((Date)new Date(), (int)-1);
            String beforeStr = DateFormatUtils.format((Date)before, (String)"yyyy-MM-dd");
            Date beforeDate = DateUtils.parseDate((String)beforeStr, (String[])new String[]{"yyyy-MM-dd"});
            List<HelpDefensePlanDetail> list = this.helpDefensePlanDetailRepository.findByHelpStatusAndHelpDate(HelpStatusEnum.IN.getDictCode(), beforeDate);
            if (CollectionUtils.isEmpty(list)) {
                return;
            }
            ArrayList<HelpDefensePlanDetailException> exceptions = new ArrayList<HelpDefensePlanDetailException>();
            for (HelpDefensePlanDetail visitPlanDetail : list) {
                visitPlanDetail.setHelpStatus(HelpStatusEnum.EXCEPTION.getDictCode());
                HelpDefensePlanDetailException exception = new HelpDefensePlanDetailException();
                exception.setHelpPlanDetailId(visitPlanDetail.getId());
                exception.setRemark("\u8ba1\u5212\u5df2\u8fc7\u671f\uff0c\u66f4\u65b0\u4e3a\u5f02\u5e38\uff01");
                exceptions.add(exception);
            }
            this.helpDefensePlanDetailRepository.saveOrUpdateBatch(list);
            this.helpDefensePlanDetailExceptionService.createBatch(exceptions);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<HelpDefensePlanDetail> findByPlanCodes(Set<String> planCodes) {
        if (CollectionUtils.isEmpty(planCodes)) {
            return new ArrayList<HelpDefensePlanDetail>(0);
        }
        return this.helpDefensePlanDetailRepository.findByPlanCodes(planCodes);
    }

    private void createValidate(HelpDefensePlanDetail helpDefensePlanDetail) {
        Validate.notNull((Object)((Object)helpDefensePlanDetail), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        helpDefensePlanDetail.setId(null);
        Validate.notBlank((CharSequence)helpDefensePlanDetail.getClientCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)helpDefensePlanDetail.getClientType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)helpDefensePlanDetail.getHelpDate(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u534f\u8bbf\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)helpDefensePlanDetail.getHelpPlanCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u534f\u8bbf\u8ba1\u5212\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)helpDefensePlanDetail.getHelpStatus(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u534f\u8bbf\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

