/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.help.defense.local.service.internal;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import com.biz.crm.sfa.business.client.sdk.strategy.ClientRouteStrategy;
import com.biz.crm.sfa.business.client.sdk.vo.ClientRouteInfoVo;
import com.biz.crm.sfa.business.help.defense.local.entity.HelpDefensePlanDetail;
import com.biz.crm.sfa.business.help.defense.local.repository.HelpDefensePlanDetailRepository;
import com.biz.crm.sfa.business.help.defense.sdk.dto.HelpDefensePlanDetailPageDto;
import com.biz.crm.sfa.business.help.defense.sdk.service.HelpDefensePlanDetailVoService;
import com.biz.crm.sfa.business.help.defense.sdk.vo.HelpDefensePlanDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class HelpDefensePlanDetailVoServiceImpl
implements HelpDefensePlanDetailVoService {
    @Autowired
    private HelpDefensePlanDetailRepository helpDefensePlanDetailRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private List<ClientRouteStrategy> clientRouteStrategies;

    public Page<HelpDefensePlanDetailVo> findByConditions(Pageable pageable, HelpDefensePlanDetailPageDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (dto == null) {
            dto = new HelpDefensePlanDetailPageDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<HelpDefensePlanDetail> page = this.helpDefensePlanDetailRepository.findByConditions(pageable, dto);
        List records = page.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            return new Page();
        }
        List<HelpDefensePlanDetailVo> helpDefensePlanDetailVos = this.buildHelpDefensePlanDetailVos(records);
        Page voPage = new Page();
        BeanUtils.copyProperties(page, (Object)voPage);
        voPage.setRecords(helpDefensePlanDetailVos);
        return voPage;
    }

    public HelpDefensePlanDetailVo findById(String id) {
        HelpDefensePlanDetail helpDefensePlanDetail = (HelpDefensePlanDetail)((Object)this.helpDefensePlanDetailRepository.getById((Serializable)((Object)id)));
        return (HelpDefensePlanDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)helpDefensePlanDetail, HelpDefensePlanDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private List<HelpDefensePlanDetailVo> buildHelpDefensePlanDetailVos(List<HelpDefensePlanDetail> records) {
        Map clientMap = records.stream().collect(Collectors.groupingBy(HelpDefensePlanDetail::getClientRoute, Collectors.groupingBy(HelpDefensePlanDetail::getClientType, Collectors.mapping(HelpDefensePlanDetail::getClientCode, Collectors.toList()))));
        Map<Object, Object> infoVoHashMap = new HashMap();
        if (!CollectionUtils.isEmpty(this.clientRouteStrategies)) {
            ArrayList infoVos = new ArrayList();
            for (ClientRouteStrategy clientRouteStrategy : this.clientRouteStrategies) {
                Map listMap = clientMap.get(clientRouteStrategy.getKey());
                if (listMap == null) continue;
                List terminalVos = clientRouteStrategy.onFindByClientCodesAndType(listMap.get(ClientTypeEnum.TERMINAL.getDictCode()), ClientTypeEnum.TERMINAL.getDictCode());
                List dealerVos = clientRouteStrategy.onFindByClientCodesAndType(listMap.get(ClientTypeEnum.DEALER.getDictCode()), ClientTypeEnum.DEALER.getDictCode());
                infoVos.addAll(terminalVos);
                infoVos.addAll(dealerVos);
            }
            if (!CollectionUtils.isEmpty(infoVos)) {
                infoVoHashMap = infoVos.stream().collect(Collectors.groupingBy(o -> StringUtils.joinWith((String)"_", (Object[])new Object[]{o.getClientRoute(), o.getClientType(), o.getClientCode()})));
            }
        }
        ArrayList<HelpDefensePlanDetailVo> helpDefensePlanDetailVos = new ArrayList<HelpDefensePlanDetailVo>();
        for (HelpDefensePlanDetail defensePlanDetail : records) {
            HelpDefensePlanDetailVo helpDefensePlanDetailVo = (HelpDefensePlanDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)defensePlanDetail, HelpDefensePlanDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
            String key = StringUtils.joinWith((String)"_", (Object[])new Object[]{helpDefensePlanDetailVo.getClientRoute(), helpDefensePlanDetailVo.getClientType(), helpDefensePlanDetailVo.getClientCode()});
            List vos = (List)infoVoHashMap.get(key);
            if (!CollectionUtils.isEmpty((Collection)vos)) {
                ClientRouteInfoVo vo = (ClientRouteInfoVo)vos.get(0);
                BeanUtil.copyProperties((Object)vo, (Object)helpDefensePlanDetailVo, (String[])new String[0]);
            }
            helpDefensePlanDetailVos.add(helpDefensePlanDetailVo);
        }
        return helpDefensePlanDetailVos;
    }
}

