/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.help.defense.local.service.internal;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.sfa.business.help.defense.local.entity.HelpDefense;
import com.biz.crm.sfa.business.help.defense.local.entity.HelpDefenseClientInfo;
import com.biz.crm.sfa.business.help.defense.local.entity.HelpDefensePlanDetail;
import com.biz.crm.sfa.business.help.defense.local.repository.HelpDefenseRepository;
import com.biz.crm.sfa.business.help.defense.local.service.HelpDefenseClientInfoService;
import com.biz.crm.sfa.business.help.defense.local.service.HelpDefensePlanDetailService;
import com.biz.crm.sfa.business.help.defense.local.service.HelpDefenseService;
import com.biz.crm.sfa.business.help.defense.sdk.enums.HelpStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="helpDefenseService")
public class HelpDefenseServiceImpl
implements HelpDefenseService {
    @Autowired
    private HelpDefenseRepository helpDefenseRepository;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired
    private HelpDefenseClientInfoService helpDefenseClientInfoService;
    @Autowired
    private HelpDefensePlanDetailService helpDefensePlanDetailService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private UserFeignVoService userFeignVoService;

    @Override
    @Transactional
    public void createBatch(List<HelpDefense> helpDefenses) {
        Validate.isTrue((!CollectionUtils.isEmpty(helpDefenses) ? 1 : 0) != 0, (String)"\u6279\u91cf\u65b0\u589e\u65f6\uff0c\u5165\u53c2\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.validateHelpPlanExist(helpDefenses);
        ArrayList<HelpDefenseClientInfo> infos = new ArrayList<HelpDefenseClientInfo>();
        ArrayList<HelpDefensePlanDetail> planDetails = new ArrayList<HelpDefensePlanDetail>();
        helpDefenses.stream().forEach(helpDefense -> {
            this.createValidate((HelpDefense)((Object)helpDefense));
            List<HelpDefenseClientInfo> clientInfos = helpDefense.getClientInfos();
            if (!CollectionUtils.isEmpty(clientInfos)) {
                for (HelpDefenseClientInfo clientInfo : clientInfos) {
                    clientInfo.setHelpPlanCode(helpDefense.getHelpPlanCode());
                    HelpDefensePlanDetail helpDefensePlanDetail = (HelpDefensePlanDetail)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)clientInfo, HelpDefensePlanDetail.class, HashSet.class, ArrayList.class, new String[0])));
                    helpDefensePlanDetail.setHelpDate(helpDefense.getHelpDefenseDate());
                    helpDefensePlanDetail.setHelpStatus(HelpStatusEnum.NO.getDictCode());
                    infos.add(clientInfo);
                    planDetails.add(helpDefensePlanDetail);
                }
            }
        });
        this.helpDefenseRepository.saveBatch(helpDefenses);
        this.helpDefenseClientInfoService.createBatch(infos);
        this.helpDefensePlanDetailService.createBatch(planDetails);
    }

    @Override
    @Transactional
    public void update(JSONObject object) {
        Validate.notNull((Object)object, (String)"\u7f16\u8f91\u65f6\uff0c\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String id = object.getString("id");
        Validate.notBlank((CharSequence)id, (String)"\u7f16\u8f91\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        JSONArray helpDefensesArr = object.getJSONArray("helpDefenses");
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)helpDefensesArr) ? 1 : 0) != 0, (String)"\u7f16\u8f91\u65f6\uff0c\u534f\u8bbf\u8ba1\u5212\u6570\u636e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List helpDefenses = JSONArray.parseArray((String)helpDefensesArr.toJSONString(), HelpDefense.class);
        HelpDefense defense = (HelpDefense)((Object)this.helpDefenseRepository.getById((Serializable)((Object)id)));
        Validate.notNull((Object)((Object)defense), (String)"\u7f16\u8f91\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u6570\u636e\uff01", (Object[])new Object[0]);
        List<HelpDefensePlanDetail> defenseList = this.helpDefensePlanDetailService.findByHelpUserNameAndHelpDate(defense.getHelpUserName(), defense.getHelpDefenseDate());
        if (!CollectionUtils.isEmpty(defenseList)) {
            this.validateHelpDetailAllStatusNo(helpDefenses, defenseList);
            List<String> ids = defenseList.stream().map(UuidEntity::getId).collect(Collectors.toList());
            this.helpDefensePlanDetailService.delete(ids);
        }
        this.helpDefenseRepository.updateDelFlagByHelpDefenseDateAndHelpUserName(defense.getHelpDefenseDate(), defense.getHelpUserName(), DelFlagStatusEnum.DELETE);
        this.createBatch(helpDefenses);
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<HelpDefense> list = this.helpDefenseRepository.findByIds(idList);
        Validate.isTrue((!CollectionUtils.isEmpty(list) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u76f8\u5173\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        Set<String> planCodes = list.stream().map(HelpDefense::getHelpPlanCode).collect(Collectors.toSet());
        List<HelpDefensePlanDetail> defensePlanDetails = this.helpDefensePlanDetailService.findByPlanCodes(planCodes);
        if (!CollectionUtils.isEmpty(defensePlanDetails)) {
            this.validateHelpDetailAllStatusNo(list, defensePlanDetails);
        }
        this.helpDefenseRepository.removeByIds(idList);
    }

    @Override
    @Transactional
    public void enable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u542f\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.helpDefenseRepository.updateEnableStatusByIds(idList, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.helpDefenseRepository.updateEnableStatusByIds(idList, EnableStatusEnum.DISABLE);
    }

    private void createValidate(HelpDefense helpDefense) {
        List coverUserVoList;
        Validate.notNull((Object)((Object)helpDefense), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        helpDefense.setId(null);
        helpDefense.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        helpDefense.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        helpDefense.setTenantCode(TenantUtils.getTenantCode());
        helpDefense.setHelpDefenseYearMonth(DateUtil.format((Date)helpDefense.getHelpDefenseDate(), (DateFormat)DateUtil.newSimpleFormat((String)"yyyy-MM")));
        helpDefense.setHelpPlanCode((String)this.generateCodeService.generateCode("XFJH", 1).get(0));
        List userVoList = this.userFeignVoService.findByUserNames((List)Lists.newArrayList((Object[])new String[]{helpDefense.getHelpUserName()}));
        if (!CollectionUtils.isEmpty((Collection)userVoList)) {
            UserVo userVo = (UserVo)userVoList.stream().findFirst().get();
            helpDefense.setHelpPosCode(userVo.getPositionCode());
            helpDefense.setHelpPosName(userVo.getPositionName());
            helpDefense.setHelpOrgCode(userVo.getOrgCode());
            helpDefense.setHelpOrgName(userVo.getOrgName());
        }
        if (!CollectionUtils.isEmpty((Collection)(coverUserVoList = this.userFeignVoService.findByUserNames((List)Lists.newArrayList((Object[])new String[]{helpDefense.getCoverHelpUserName()}))))) {
            UserVo userVo = (UserVo)coverUserVoList.stream().findFirst().get();
            helpDefense.setCoverHelpPosCode(userVo.getPositionCode());
            helpDefense.setCoverHelpPosName(userVo.getPositionName());
            helpDefense.setCoverHelpOrgCode(userVo.getOrgCode());
            helpDefense.setCoverHelpOrgName(userVo.getOrgName());
        }
        Validate.notBlank((CharSequence)helpDefense.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)helpDefense.getCoverHelpUserName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u88ab\u534f\u8bbf\u4eba\u5458\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)helpDefense.getHelpDefenseDate(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u534f\u8bbf\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)helpDefense.getHelpPlanCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u534f\u8bbf\u8ba1\u5212\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)helpDefense.getHelpUserName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u62dc\u8bbf\u8ba1\u5212\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(helpDefense.getClientInfos()) ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        HelpDefense helpDefenseData = this.helpDefenseRepository.findByUserNameAndHelpDefenseDate(TenantUtils.getTenantCode(), helpDefense.getHelpUserName(), helpDefense.getCoverHelpUserName(), helpDefense.getHelpDefenseDate());
        Validate.isTrue((helpDefenseData == null ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u534f\u8bbf\u4eba\u5458\u8d26\u53f7\uff1a%s\uff0c\u88ab\u534f\u8bbf\u4eba\u5458\u8d26\u53f7\uff1a%s\uff0c\u534f\u8bbf\u65e5\u671f\uff1a%S\uff0c\u7684\u6570\u636e\u5df2\u5b58\u5728\uff01", (Object[])new Object[]{helpDefense.getHelpUserName(), helpDefense.getCoverHelpUserName(), DateFormatUtils.format((Date)helpDefense.getHelpDefenseDate(), (String)"yyyy-MM-dd")});
        try {
            String nowDateStr = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd");
            Date nowDate = DateUtils.parseDate((String)nowDateStr, (String[])new String[]{"yyyy-MM-dd"});
            Validate.isTrue((helpDefense.getHelpDefenseDate().compareTo(nowDate) >= 0 && helpDefense.getHelpDefenseDate().compareTo(DateUtils.addDays((Date)nowDate, (int)7)) <= 0 ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6, \u62dc\u8bbf\u65f6\u95f4\u53ea\u80fd\u8bbe\u7f6e\u672a\u67657\u5929\u5185\uff01", (Object[])new Object[0]);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private void validateHelpPlanExist(List<HelpDefense> helpDefenses) {
        HashSet<String> userNames = new HashSet<String>();
        HashSet<String> covertUserNames = new HashSet<String>();
        HashSet<Date> helpDates = new HashSet<Date>();
        for (HelpDefense helpDefense2 : helpDefenses) {
            userNames.add(helpDefense2.getHelpUserName());
            covertUserNames.add(helpDefense2.getCoverHelpUserName());
            helpDates.add(helpDefense2.getHelpDefenseDate());
        }
        List<HelpDefense> defenses = this.helpDefenseRepository.findByHelpUserNamesAndCovertUserNamesAndHelpDates(userNames, covertUserNames, helpDates);
        if (!CollectionUtils.isEmpty(defenses)) {
            Map<String, List<HelpDefense>> listMap = defenses.stream().collect(Collectors.groupingBy(helpDefense -> StringUtils.joinWith((String)"_", (Object[])new Object[]{helpDefense.getHelpUserName(), helpDefense.getCoverHelpUserName(), helpDefense.getHelpDefenseDate()})));
            for (HelpDefense helpDefens : helpDefenses) {
                String key = StringUtils.joinWith((String)"_", (Object[])new Object[]{helpDefens.getHelpUserName(), helpDefens.getCoverHelpUserName(), helpDefens.getHelpDefenseDate()});
                Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)listMap.get(key)), (String)"\u534f\u9632\u4eba\u3010%s\u3011\u914d\u7f6e\u7684\u88ab\u534f\u9632\u4eba\u3010%s\u3011\u5728\u3010%s\u3011\u5b58\u5728\u534f\u8bbf\u8ba1\u5212\uff01", (Object[])new Object[]{helpDefens.getHelpRealName(), helpDefens.getCoverHelpRealName(), DateFormatUtils.format((Date)helpDefens.getHelpDefenseDate(), (String)"yyyy-MM-dd")});
            }
        }
    }

    private void validateHelpDetailAllStatusNo(List<HelpDefense> helpDefenses, List<HelpDefensePlanDetail> defenseList) {
        List notNoDetails = defenseList.stream().filter(helpDefensePlanDetail -> !helpDefensePlanDetail.getHelpStatus().equals(HelpStatusEnum.NO.getDictCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(notNoDetails)) {
            return;
        }
        Set<String> stringSet = notNoDetails.stream().map(HelpDefensePlanDetail::getHelpPlanCode).collect(Collectors.toSet());
        List<HelpDefense> list = this.helpDefenseRepository.findByPlanCodes(stringSet);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Map<String, List<HelpDefense>> listMap = list.stream().collect(Collectors.groupingBy(helpDefense -> StringUtils.joinWith((String)"_", (Object[])new Object[]{helpDefense.getHelpUserName(), helpDefense.getCoverHelpUserName(), helpDefense.getHelpDefenseDate()})));
        for (HelpDefense helpDefens : helpDefenses) {
            String key = StringUtils.joinWith((String)"_", (Object[])new Object[]{helpDefens.getHelpUserName(), helpDefens.getCoverHelpUserName(), helpDefens.getHelpDefenseDate()});
            Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)listMap.get(key)), (String)"\u5f53\u524d\u5b58\u5728\u62dc\u8bbf\u4efb\u52a1\uff0c\u4e0d\u5141\u8bb8\u7f16\u8f91\u6216\u8005\u5220\u9664\uff01", (Object[])new Object[0]);
        }
    }
}

