/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.help.defense.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.sfa.business.help.defense.local.entity.HelpDefense;
import com.biz.crm.sfa.business.help.defense.local.entity.HelpDefenseClientInfo;
import com.biz.crm.sfa.business.help.defense.local.repository.HelpDefenseClientInfoRepository;
import com.biz.crm.sfa.business.help.defense.local.repository.HelpDefenseRepository;
import com.biz.crm.sfa.business.help.defense.sdk.dto.HelpDefenseQueryDto;
import com.biz.crm.sfa.business.help.defense.sdk.service.HelpDefenseVoService;
import com.biz.crm.sfa.business.help.defense.sdk.vo.HelpDefenseClientInfoVo;
import com.biz.crm.sfa.business.help.defense.sdk.vo.HelpDefenseVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class HelpDefenseVoServiceImpl
implements HelpDefenseVoService {
    @Autowired
    private HelpDefenseRepository helpDefenseRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private HelpDefenseClientInfoRepository helpDefenseClientInfoRepository;
    @Autowired
    private UserFeignVoService userFeignVoService;

    public Page<HelpDefenseVo> findByConditions(Pageable pageable, HelpDefenseQueryDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new HelpDefenseQueryDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<HelpDefense> page = this.helpDefenseRepository.findByConditions(pageable, dto);
        List records = page.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            return new Page();
        }
        Page voPage = new Page();
        BeanUtils.copyProperties(page, (Object)voPage);
        List helpDefenseVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)records, HelpDefense.class, HelpDefenseVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.buildHelpDefenseVo(helpDefenseVos);
        voPage.setRecords(helpDefenseVos);
        return voPage;
    }

    public HelpDefenseVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        HelpDefense helpDefense = (HelpDefense)((Object)this.helpDefenseRepository.getById((Serializable)((Object)id)));
        if (helpDefense == null) {
            return null;
        }
        HelpDefenseVo helpDefenseVo = (HelpDefenseVo)this.nebulaToolkitService.copyObjectByBlankList((Object)helpDefense, HelpDefenseVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.buildHelpDefenseVo(Lists.newArrayList((Object[])new HelpDefenseVo[]{helpDefenseVo}));
        List<HelpDefenseClientInfo> clientInfos = this.helpDefenseClientInfoRepository.findByHelpPlanCodes(helpDefense.getHelpPlanCode());
        if (!CollectionUtils.isEmpty(clientInfos)) {
            List helpDefenseClientInfoVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(clientInfos, HelpDefenseClientInfo.class, HelpDefenseClientInfoVo.class, HashSet.class, ArrayList.class, new String[0]);
            helpDefenseVo.setClientInfoVos(helpDefenseClientInfoVos);
        }
        return helpDefenseVo;
    }

    public HelpDefenseVo findByPlanCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        HelpDefense helpDefense = this.helpDefenseRepository.findByPlanCode(code);
        if (helpDefense == null) {
            return null;
        }
        HelpDefenseVo helpDefenseVo = (HelpDefenseVo)this.nebulaToolkitService.copyObjectByBlankList((Object)helpDefense, HelpDefenseVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.buildHelpDefenseVo(Lists.newArrayList((Object[])new HelpDefenseVo[]{helpDefenseVo}));
        List<HelpDefenseClientInfo> clientInfos = this.helpDefenseClientInfoRepository.findByHelpPlanCodes(helpDefense.getHelpPlanCode());
        if (!CollectionUtils.isEmpty(clientInfos)) {
            List helpDefenseClientInfoVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(clientInfos, HelpDefenseClientInfo.class, HelpDefenseClientInfoVo.class, HashSet.class, ArrayList.class, new String[0]);
            helpDefenseVo.setClientInfoVos(helpDefenseClientInfoVos);
        }
        return helpDefenseVo;
    }

    private void buildHelpDefenseVo(List<HelpDefenseVo> helpDefenseVos) {
        if (CollectionUtils.isEmpty(helpDefenseVos)) {
            return;
        }
        HashSet userNames = new HashSet();
        helpDefenseVos.stream().forEach(helpDefenseVo -> {
            userNames.add(helpDefenseVo.getHelpUserName());
            userNames.add(helpDefenseVo.getCoverHelpUserName());
        });
        List userVoList = this.userFeignVoService.findByUserNames((List)Lists.newArrayList(userNames));
        if (CollectionUtils.isEmpty((Collection)userVoList)) {
            return;
        }
        Map<String, UserVo> userVoMap = userVoList.stream().filter(userVo -> StringUtils.isNotBlank((CharSequence)userVo.getUserName())).collect(Collectors.toMap(UserVo::getUserName, a -> a));
        helpDefenseVos.stream().forEach(helpDefenseVo -> {
            UserVo userVo = (UserVo)userVoMap.get(helpDefenseVo.getHelpUserName());
            if (userVo != null) {
                helpDefenseVo.setHelpPostCode(userVo.getPositionCode());
                helpDefenseVo.setHelpPostName(userVo.getPositionName());
                helpDefenseVo.setHelpOrgCode(userVo.getOrgCode());
                helpDefenseVo.setHelpOrgName(userVo.getOrgName());
            }
        });
    }
}

