/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.help.defense.local.service.strategy;

import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.help.defense.local.entity.HelpDefensePlanDetail;
import com.biz.crm.sfa.business.help.defense.local.entity.HelpDefensePlanDetailPerformance;
import com.biz.crm.sfa.business.help.defense.local.repository.HelpDefensePlanDetailRepository;
import com.biz.crm.sfa.business.help.defense.local.service.HelpDefensePlanDetailPerformanceService;
import com.biz.crm.sfa.business.help.defense.sdk.enums.HelpStatusEnum;
import com.biz.crm.sfa.business.step.sdk.enums.VisitTypeEnum;
import com.biz.crm.sfa.business.step.sdk.strategy.ExecutePlanCallBackStrategy;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class ExecutePlanCallBackStrategyForHelpDefense
implements ExecutePlanCallBackStrategy {
    @Autowired
    private HelpDefensePlanDetailPerformanceService helpDefensePlanDetailPerformanceService;
    @Autowired
    private HelpDefensePlanDetailRepository helpDefensePlanDetailRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    public String visitType() {
        return VisitTypeEnum.HELP_DEFENSE.getDictCode();
    }

    public String visitName() {
        return VisitTypeEnum.HELP_DEFENSE.getValue();
    }

    @Transactional
    public void onSave(String parentCode, String dynamicKey, String dynamicFormCode) {
        Validate.notBlank((CharSequence)parentCode, (String)"\u4fdd\u5b58\u5b8c\u6210\u60c5\u51b5\u65f6\uff0c\u7236\u7ea7\u5173\u8054\u552f\u4e00\u7f16\u7801\uff08\u660e\u7ec6id\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dynamicKey, (String)"\u4fdd\u5b58\u5b8c\u6210\u60c5\u51b5\u65f6\uff0c\u52a8\u6001key\uff08\u6b65\u9aa4\u7f16\u7801\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dynamicFormCode, (String)"\u4fdd\u5b58\u5b8c\u6210\u60c5\u51b5\u65f6\uff0c\u8868\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        HelpDefensePlanDetailPerformance helpDefensePlanDetailPerformance = new HelpDefensePlanDetailPerformance();
        helpDefensePlanDetailPerformance.setHelpDefensePlanDetailId(parentCode);
        helpDefensePlanDetailPerformance.setStepCode(dynamicKey);
        helpDefensePlanDetailPerformance.setFormCode(dynamicFormCode);
        this.helpDefensePlanDetailPerformanceService.create(helpDefensePlanDetailPerformance);
    }

    @Transactional
    public void onUpdateExecuteStatus(Boolean completeOrNot, String parentCode) {
        Date planDateTime = new Date();
        HelpDefensePlanDetail helpDefensePlanDetail = (HelpDefensePlanDetail)((Object)this.helpDefensePlanDetailRepository.getById((Serializable)((Object)parentCode)));
        Validate.notNull((Object)((Object)helpDefensePlanDetail), (String)"\u66f4\u6539\u534f\u8bbf\u72b6\u6001\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u76f8\u5173\u7684\u534f\u8bbf\u6570\u636e", (Object[])new Object[0]);
        if (completeOrNot.booleanValue()) {
            helpDefensePlanDetail.setHelpStatus(HelpStatusEnum.COMPLETE.getDictCode());
            helpDefensePlanDetail.setHelpEndDate(planDateTime);
        } else {
            LoginUserDetails loginDetails = (LoginUserDetails)this.loginUserService.getLoginDetails(LoginUserDetails.class);
            List<HelpDefensePlanDetail> byUserNameAndVisitDate = this.helpDefensePlanDetailRepository.findByUserNameAndVisitDate(loginDetails.getAccount(), helpDefensePlanDetail.getHelpDate());
            List planDetails = byUserNameAndVisitDate.stream().filter(visitPlanDetail1 -> visitPlanDetail1.getHelpStatus().equals(HelpStatusEnum.IN.getDictCode())).collect(Collectors.toList());
            Validate.isTrue((boolean)CollectionUtils.isEmpty(planDetails), (String)"\u5b58\u5728\u534f\u8bbf\u4e2d\u7684\u8ba1\u5212\uff0c\u8bf7\u5b8c\u6210\u540e\u518d\u6b21\u62dc\u8bbf\uff01", (Object[])new Object[0]);
            helpDefensePlanDetail.setHelpStatus(HelpStatusEnum.IN.getDictCode());
            if (helpDefensePlanDetail.getHelpStartDate() == null) {
                helpDefensePlanDetail.setHelpStartDate(planDateTime);
            }
        }
        this.helpDefensePlanDetailRepository.saveOrUpdate((Object)helpDefensePlanDetail);
    }

    public Set<String> onFindUserNamesByNowAndExecuteStatusIn() {
        try {
            String nowDateStr = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd");
            Date nowDate = DateUtils.parseDate((String)nowDateStr, (String[])new String[]{"yyyy-MM-dd"});
            Set<String> userNames = this.helpDefensePlanDetailRepository.findUserNamesByHelpStatusAndHelpDate(HelpStatusEnum.IN.getDictCode(), nowDate);
            return userNames;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }
}

