package com.biz.crm.sfa.business.help.defense.local.controller;


import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.help.defense.local.service.HelpDefensePlanDetailService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 协访计划明细表(HelpDefensePlanDetail)表相关的http接口
 *
 * @author songjingen
 * @since 2022-06-07 15:43:21
 */
@RestController
@RequestMapping("/v1/helpDefense/helpDefensePlanDetail")
@Slf4j
@Api(tags = "协访管理：HelpDefensePlanDetail：协访计划明细表")
public class HelpDefensePlanDetailController {
  /**
   * 服务对象
   */
  @Autowired
  private HelpDefensePlanDetailService helpDefensePlanDetailService;
  @Autowired(required = false)
  private LoginUserService loginUserService;

  /**
   * 删除数据（单个或者批量）
   *
   * @param ids 主键集合
   * @return 删除结果
   */
  @DeleteMapping
  @ApiOperation(value = "删除数据（单个或者批量）")
  public Result<?> delete(@ApiParam(name = "ids", value = "主键集合") @RequestParam("ids") List<String> ids) {
    try {
      this.helpDefensePlanDetailService.delete(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 查看当前用户的进度接口
   *
   * @return {"completed":"已完成数量","total":"总数量"}
   */
  @ApiOperation("查看进度接口")
  @GetMapping("findScheduleByCurrentUserAndVisitDate")
  public Result<?> findScheduleByCurrentUserAndVisitDate(@ApiParam(name = "visitDate", value = "拜访日期") @RequestParam("visitDate") @DateTimeFormat(pattern = "yyyy-MM-dd") Date visitDate) {
    try {
      FacturerUserDetails loginDetails = this.loginUserService.getLoginDetails(FacturerUserDetails.class);
      Map<String, Integer> map = this.helpDefensePlanDetailService.findScheduleByUserNameAndVisitDate(loginDetails.getAccount(), visitDate);
      return Result.ok(map);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 执行任务，每天零时5分结束前一天的协访中任务
   */
  @ApiOperation("执行任务，每天零时5分结束前一天的协访中任务")
  @PostMapping("executeTask")
  public Result<?> executeTask() {
    try {
      this.helpDefensePlanDetailService.executeTask();
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
