package com.biz.crm.sfa.business.help.defense.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.Date;
import java.util.List;

/**
 * 协访计划制定表
 *
 * @author songjingen
 */
@Getter
@Setter
@Entity
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_help_defense")
@Table(name = "sfa_help_defense", indexes = {
    @Index(name = "sfa_help_defense_index1", columnList = "help_plan_code,tenant_code", unique = true)
})
@ApiModel(value = "HelpDefense", description = "协访计划制定表")
@org.hibernate.annotations.Table(appliesTo = "sfa_help_defense", comment = "协访计划制定表")
public class HelpDefense extends TenantFlagOpEntity {

  private static final long serialVersionUID = -4442779125977878918L;

  /**
   * 协访计划编码
   */
  @ApiModelProperty("协访计划编码")
  @Column(name = "help_plan_code", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '协访计划编码'")
  private String helpPlanCode;
  /**
   * 协访人员账号
   */
  @ApiModelProperty("协访人员账号")
  @Column(name = "help_user_name", length = 255, nullable = false, columnDefinition = "varchar(255) COMMENT '拜访计划编码'")
  private String helpUserName;
  /**
   * 协访人员姓名
   */
  @ApiModelProperty("协访人员姓名")
  @Column(name = "help_real_name", length = 255, columnDefinition = "varchar(255) COMMENT '协访人员姓名'")
  private String helpRealName;
  /**
   * 协访人员职位编码
   */
  @ApiModelProperty("协访人员职位编码")
  @Column(name = "help_pos_code", length = 255, columnDefinition = "varchar(255) COMMENT '协访人员职位编码'")
  private String helpPosCode;
  /**
   * 协访人员职位名称
   */
  @ApiModelProperty("协访人员职位名称")
  @Column(name = "help_pos_name", length = 255, columnDefinition = "varchar(255) COMMENT '协访人员职位名称'")
  private String helpPosName;
  /**
   * 协访人员职位编码
   */
  @ApiModelProperty("协访人员组织编码")
  @Column(name = "help_org_code", length = 255, columnDefinition = "varchar(255) COMMENT '协访人员职位编码'")
  private String helpOrgCode;
  /**
   * 协访人员职位名称
   */
  @ApiModelProperty("协访人员组织名称")
  @Column(name = "help_org_name", length = 255, columnDefinition = "varchar(255) COMMENT '协访人员职位名称'")
  private String helpOrgName;

  /**
   * 协访日期
   */
  @ApiModelProperty("协访日期")
  @Column(name = "help_defense_date", length = 20, nullable = false, columnDefinition = "date COMMENT '协访日期'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date helpDefenseDate;

  /**
   * 被协访人员账号
   */
  @ApiModelProperty("被协访人员账号")
  @Column(name = "cover_help_user_name", length = 255, nullable = false, columnDefinition = "varchar(255) COMMENT '被协访人员账号'")
  private String coverHelpUserName;

  /**
   * 被协访人员姓名
   */
  @ApiModelProperty("被协访人员姓名")
  @Column(name = "cover_help_real_name", length = 255, columnDefinition = "varchar(255) COMMENT '被协访人员姓名'")
  private String coverHelpRealName;

  /**
   * 被协访人员职位编码
   */
  @ApiModelProperty("被协访人员职位编码")
  @Column(name = "cover_help_pos_code", length = 255, columnDefinition = "varchar(255) COMMENT '协访人员职位编码'")
  private String coverHelpPosCode;
  /**
   * 被协访人员职位名称
   */
  @ApiModelProperty("被协访人员职位名称")
  @Column(name = "cover_help_pos_name", length = 255, columnDefinition = "varchar(255) COMMENT '协访人员职位名称'")
  private String coverHelpPosName;
  /**
   * 被协访人员职位编码
   */
  @ApiModelProperty("被协访人员组织编码")
  @Column(name = "cover_help_org_code", length = 255, columnDefinition = "varchar(255) COMMENT '协访人员职位编码'")
  private String coverHelpOrgCode;
  /**
   * 被协访人员职位名称
   */
  @ApiModelProperty("被协访人员组织名称")
  @Column(name = "cover_help_org_name", length = 255, columnDefinition = "varchar(255) COMMENT '协访人员职位名称'")
  private String coverHelpOrgName;

  /**
   * 协访计划年月
   */
  @ApiModelProperty("协访计划年月")
  @Column(name = "help_defense_year_month", length = 255, columnDefinition = "varchar(255) COMMENT '协访计划年月'")
  private String helpDefenseYearMonth;

  /**
   * 被协访人客户信息数量
   */
  @ApiModelProperty("被协访人客户信息数量")
  @Transient
  @TableField(exist = false)
  private Integer clientInfoCount;

  /**
   * 被协访人客户信息
   */
  @ApiModelProperty("被协访人客户信息")
  @Transient
  @TableField(exist = false)
  private List<HelpDefenseClientInfo> clientInfos;

}
