package com.biz.crm.sfa.business.help.defense.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.help.defense.local.entity.HelpDefensePlanDetail;
import com.biz.crm.sfa.business.help.defense.sdk.dto.HelpDefensePlanDetailPageDto;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 协访计划明细表(HelpDefensePlanDetail)表mybatis访问层
 *
 * @author songjingen
 * @since 2022-06-07 15:43:22
 */
public interface HelpDefensePlanDetailMapper extends BaseMapper<HelpDefensePlanDetail> {

  /**
   * 分页查询所有数据
   *
   * @param page 分页对象
   * @param dto  查询实体
   * @return 所有数据
   */
  public Page<HelpDefensePlanDetail> findByConditions(@Param("page") Page<HelpDefensePlanDetail> page, @Param("dto") HelpDefensePlanDetailPageDto dto);

  /**
   * 根据用户编码查询数据
   *
   * @param userName
   * @param visitDate
   * @return
   */
  List<HelpDefensePlanDetail> findByUserNameAndVisitDate(@Param("userName") String userName, @Param("visitDate") Date visitDate);

  /**
   * 查询 状态、时间、查询用户账号集合
   *
   * @param helpStatus
   * @param helpDate
   * @return
   */
  Set<String> findUserNamesByHelpStatusAndHelpDate(@Param("helpStatus") String helpStatus, @Param("helpDate") Date helpDate);
}

