package com.biz.crm.sfa.business.help.defense.local.observer;

import com.biz.crm.sfa.business.help.defense.sdk.service.HelpDefensePlanDetailVoService;
import com.biz.crm.sfa.business.help.defense.sdk.service.HelpDefenseVoService;
import com.biz.crm.sfa.business.help.defense.sdk.vo.HelpDefensePlanDetailVo;
import com.biz.crm.sfa.business.help.defense.sdk.vo.HelpDefenseVo;
import com.biz.crm.sfa.business.template.visit.evaluate.sdk.listener.HelpDefenseListener;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 协访计划监听实现
 *
 * @author jerry7
 */
@Component
public class HelpDefenseListenerImpl implements HelpDefenseListener {

  @Autowired
  private HelpDefensePlanDetailVoService helpDefensePlanDetailVoService;

  @Autowired
  private HelpDefenseVoService helpDefenseVoService;

  @Override
  public String getCoverHelpUserNameByParentCode(String parentCode) {
    if (StringUtils.isBlank(parentCode)) {
      return null;
    }
    HelpDefensePlanDetailVo helpDefensePlanDetailVo = this.helpDefensePlanDetailVoService.findById(parentCode);
    if (!ObjectUtils.isNotEmpty(helpDefensePlanDetailVo)) {
      return null;
    }
    HelpDefenseVo helpDefenseVo = helpDefenseVoService.findByPlanCode(helpDefensePlanDetailVo.getHelpPlanCode());
    return helpDefenseVo.getCoverHelpUserName();
  }
}
