package com.biz.crm.sfa.business.help.defense.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.help.defense.local.entity.HelpDefensePlanDetailPerformance;
import com.biz.crm.sfa.business.help.defense.local.mapper.HelpDefensePlanDetailPerformanceMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 协访计划明细完成情况表(HelpDefensePlanDetailPerformance)表数据库访问层
 *
 * @author songjingen
 * @since 2022-06-21 16:41:43
 */
@Component
public class HelpDefensePlanDetailPerformanceRepository extends ServiceImpl<HelpDefensePlanDetailPerformanceMapper, HelpDefensePlanDetailPerformance> {

  /**
   * 根据明细id查询数据
   *
   * @param id
   * @return
   */
  public List<HelpDefensePlanDetailPerformance> findByDetailId(String id) {
    return this.lambdaQuery().eq(HelpDefensePlanDetailPerformance::getHelpDefensePlanDetailId, id)
        .orderByAsc(HelpDefensePlanDetailPerformance::getCreateTime)
        .list();
  }
}

