package com.biz.crm.sfa.business.help.defense.local.service.internal;


import com.biz.crm.sfa.business.help.defense.local.entity.HelpDefenseClientInfo;
import com.biz.crm.sfa.business.help.defense.local.repository.HelpDefenseClientInfoRepository;
import com.biz.crm.sfa.business.help.defense.local.service.HelpDefenseClientInfoService;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 协访计划客户信息表(HelpDefenseClientInfo)表服务实现类
 *
 * @author songjingen
 * @since 2022-05-19 11:21:58
 */
@Service("helpDefenseClientInfoService")
public class HelpDefenseClientInfoServiceImpl implements HelpDefenseClientInfoService {

  @Autowired
  private HelpDefenseClientInfoRepository helpDefenseClientInfoRepository;

  /**
   * 创建验证
   *
   * @param helpDefenseClientInfo
   */
  private void createValidate(HelpDefenseClientInfo helpDefenseClientInfo) {
    Validate.notNull(helpDefenseClientInfo, "新增时，对象信息不能为空！");
    helpDefenseClientInfo.setId(null);
    Validate.notBlank(helpDefenseClientInfo.getClientCode(), "新增数据时，客户编码不能为空！");
    Validate.notBlank(helpDefenseClientInfo.getClientType(), "新增数据时，客户类型不能为空！");
    Validate.notBlank(helpDefenseClientInfo.getHelpPlanCode(), "新增数据时，协访计划编码不能为空！");

  }

  @Override
  public void createBatch(List<HelpDefenseClientInfo> helpDefenseClientInfos) {
    Validate.isTrue(!CollectionUtils.isEmpty(helpDefenseClientInfos), "新增被协访人客户信息时，客户信息不能为空！");
    helpDefenseClientInfos.stream().forEach(this::createValidate);
    this.helpDefenseClientInfoRepository.saveBatch(helpDefenseClientInfos);
  }

  @Override
  public void deleteByHelpPlanCode(List<String> helpPlanCodes) {
    this.helpDefenseClientInfoRepository.deleteByHelpPlanCode(helpPlanCodes);
  }
}

