package com.biz.crm.sfa.business.help.defense.local.service.internal;


import com.biz.crm.sfa.business.help.defense.local.entity.HelpDefensePlanDetailExceptionFile;
import com.biz.crm.sfa.business.help.defense.local.repository.HelpDefensePlanDetailExceptionFileRepository;
import com.biz.crm.sfa.business.help.defense.local.service.HelpDefensePlanDetailExceptionFileService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 协访计划明细异常文件表(HelpDefensePlanDetailExceptionFile)表服务实现类
 *
 * @author songjingen
 * @since 2022-06-28 20:08:22
 */
@Service("helpDefensePlanDetailExceptionFileService")
public class HelpDefensePlanDetailExceptionFileServiceImpl implements HelpDefensePlanDetailExceptionFileService {

  @Autowired
  private HelpDefensePlanDetailExceptionFileRepository helpDefensePlanDetailExceptionFileRepository;


  /**
   * 创建验证
   *
   * @param helpDefensePlanDetailExceptionFile
   */
  private void createValidate(HelpDefensePlanDetailExceptionFile helpDefensePlanDetailExceptionFile) {
    Validate.notNull(helpDefensePlanDetailExceptionFile, "新增时，对象信息不能为空！");
    helpDefensePlanDetailExceptionFile.setId(null);
    helpDefensePlanDetailExceptionFile.setTenantCode(TenantUtils.getTenantCode());
    Validate.notBlank(helpDefensePlanDetailExceptionFile.getHelpPlanDetailExceptionId(), "新增数据时，协访计划明细异常id不能为空！");

  }

  @Transactional
  @Override
  public void createBatch(List<HelpDefensePlanDetailExceptionFile> helpDefensePlanDetailExceptionFiles) {
    Validate.isTrue(!CollectionUtils.isEmpty(helpDefensePlanDetailExceptionFiles), "新增数据时，入参集合不能为空！");
    helpDefensePlanDetailExceptionFiles.forEach(this::createValidate);
    this.helpDefensePlanDetailExceptionFileRepository.saveBatch(helpDefensePlanDetailExceptionFiles);
  }

  @Override
  public List<HelpDefensePlanDetailExceptionFile> findByExceptionIds(List<String> exceptionIds) {
    if (CollectionUtils.isEmpty(exceptionIds)) {
      return new ArrayList<>(0);
    }
    return this.helpDefensePlanDetailExceptionFileRepository.findByExceptionIds(exceptionIds);
  }
}

