package com.biz.crm.sfa.business.help.defense.local.service.internal;


import com.biz.crm.sfa.business.help.defense.local.entity.HelpDefensePlanDetailException;
import com.biz.crm.sfa.business.help.defense.local.entity.HelpDefensePlanDetailExceptionFile;
import com.biz.crm.sfa.business.help.defense.local.repository.HelpDefensePlanDetailExceptionRepository;
import com.biz.crm.sfa.business.help.defense.local.repository.HelpDefensePlanDetailRepository;
import com.biz.crm.sfa.business.help.defense.local.service.HelpDefensePlanDetailExceptionFileService;
import com.biz.crm.sfa.business.help.defense.local.service.HelpDefensePlanDetailExceptionService;
import com.biz.crm.sfa.business.help.defense.sdk.enums.HelpStatusEnum;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 协访计划明细异常表(HelpDefensePlanDetailException)表服务实现类
 *
 * @author songjingen
 * @since 2022-06-28 20:08:22
 */
@Service("helpDefensePlanDetailExceptionService")
public class HelpDefensePlanDetailExceptionServiceImpl implements HelpDefensePlanDetailExceptionService {

  @Autowired
  private HelpDefensePlanDetailExceptionRepository helpDefensePlanDetailExceptionRepository;
  @Autowired
  private HelpDefensePlanDetailExceptionFileService helpDefensePlanDetailExceptionFileService;
  @Autowired
  private HelpDefensePlanDetailRepository helpDefensePlanDetailRepository;

  /**
   * 新增数据
   *
   * @param helpDefensePlanDetailException 实体对象
   * @return 新增结果
   */
  @Transactional
  @Override
  public HelpDefensePlanDetailException create(HelpDefensePlanDetailException helpDefensePlanDetailException) {
    this.createValidate(helpDefensePlanDetailException);
    this.helpDefensePlanDetailExceptionRepository.saveOrUpdate(helpDefensePlanDetailException);
    //保存关联信息
    List<HelpDefensePlanDetailExceptionFile> pictureList = helpDefensePlanDetailException.getPictureList();
    if (!CollectionUtils.isEmpty(pictureList)) {
      pictureList.forEach(helpDefensePlanDetailExceptionFile -> helpDefensePlanDetailExceptionFile.setHelpPlanDetailExceptionId(helpDefensePlanDetailException.getId()));
      this.helpDefensePlanDetailExceptionFileService.createBatch(pictureList);
    }
    //更改明细协访状态
    this.helpDefensePlanDetailRepository.updateHelpStatusById(HelpStatusEnum.EXCEPTION.getDictCode(), helpDefensePlanDetailException.getHelpPlanDetailId());
    return helpDefensePlanDetailException;
  }

  @Override
  public HelpDefensePlanDetailException findByHelpPlanDetailId(String helpPlanDetailId) {
    if (StringUtils.isBlank(helpPlanDetailId)) {
      return null;
    }
    List<HelpDefensePlanDetailException> helpDefensePlanDetailExceptions = this.helpDefensePlanDetailExceptionRepository.findByHelpPlanDetailId(helpPlanDetailId);
    if (CollectionUtils.isEmpty(helpDefensePlanDetailExceptions)) {
      return null;
    }
    HelpDefensePlanDetailException helpDefensePlanDetailException = helpDefensePlanDetailExceptions.get(0);
    List<HelpDefensePlanDetailExceptionFile> files = this.helpDefensePlanDetailExceptionFileService.findByExceptionIds(Lists.newArrayList(helpDefensePlanDetailException.getId()));
    helpDefensePlanDetailException.setPictureList(files);
    return helpDefensePlanDetailException;
  }

  @Transactional
  @Override
  public void createBatch(List<HelpDefensePlanDetailException> exceptions) {
    Validate.isTrue(!CollectionUtils.isEmpty(exceptions), "入参对象不能为空！");
    exceptions.forEach(this::createValidate);
    this.helpDefensePlanDetailExceptionRepository.saveBatch(exceptions);
  }

  /**
   * 创建验证
   *
   * @param helpDefensePlanDetailException
   */
  private void createValidate(HelpDefensePlanDetailException helpDefensePlanDetailException) {
    Validate.notNull(helpDefensePlanDetailException, "新增时，对象信息不能为空！");
    helpDefensePlanDetailException.setId(null);
    Validate.notBlank(helpDefensePlanDetailException.getHelpPlanDetailId(), "新增数据时，协访计划明细id不能为空！");
    Validate.notBlank(helpDefensePlanDetailException.getRemark(), "新增数据时，异常信息不能为空！");
    //验证是否已经提报异常
    List<HelpDefensePlanDetailException> exceptions = this.helpDefensePlanDetailExceptionRepository.findByHelpPlanDetailId(helpDefensePlanDetailException.getHelpPlanDetailId());
    Validate.isTrue(CollectionUtils.isEmpty(exceptions), "当前计划已提报异常！");
  }

}

