package com.biz.crm.sfa.business.help.defense.local.service.internal;


import com.biz.crm.sfa.business.help.defense.local.entity.HelpDefensePlanDetailPerformance;
import com.biz.crm.sfa.business.help.defense.local.repository.HelpDefensePlanDetailPerformanceRepository;
import com.biz.crm.sfa.business.help.defense.local.service.HelpDefensePlanDetailPerformanceService;
import com.biz.crm.sfa.business.step.sdk.service.StepFormVoService;
import com.biz.crm.sfa.business.step.sdk.vo.StepFormVo;
import com.biz.crm.sfa.business.template.sdk.abstracts.AbstractDynamicTemplateModel;
import com.biz.crm.sfa.business.template.sdk.dto.DynamicTemplateModelDto;
import com.biz.crm.sfa.business.template.sdk.service.DynamicTemplateService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 协访计划明细完成情况表(HelpDefensePlanDetailPerformance)表服务实现类
 *
 * @author songjingen
 * @since 2022-06-21 16:41:43
 */
@Service("helpDefensePlanDetailPerformanceService")
public class HelpDefensePlanDetailPerformanceServiceImpl implements HelpDefensePlanDetailPerformanceService {

  @Autowired
  private HelpDefensePlanDetailPerformanceRepository helpDefensePlanDetailPerformanceRepository;
  @Autowired(required = false)
  private StepFormVoService stepFormVoService;
  @Autowired(required = false)
  private DynamicTemplateService dynamicTemplateService;

  /**
   * 新增数据
   *
   * @param helpDefensePlanDetailPerformance 实体对象
   * @return 新增结果
   */
  @Transactional
  @Override
  public HelpDefensePlanDetailPerformance create(HelpDefensePlanDetailPerformance helpDefensePlanDetailPerformance) {
    this.createValidate(helpDefensePlanDetailPerformance);
    this.helpDefensePlanDetailPerformanceRepository.saveOrUpdate(helpDefensePlanDetailPerformance);
    return helpDefensePlanDetailPerformance;
  }


  @Override
  public List<HelpDefensePlanDetailPerformance> findByDetailId(String id) {
    if (StringUtils.isBlank(id)) {
      return new ArrayList<>();
    }
    List<HelpDefensePlanDetailPerformance> detailPerformances = this.helpDefensePlanDetailPerformanceRepository.findByDetailId(id);
    if (CollectionUtils.isEmpty(detailPerformances)) {
      return new ArrayList<>(0);
    }
    Set<String> stepCodes = detailPerformances.stream().map(HelpDefensePlanDetailPerformance::getStepCode).collect(Collectors.toSet());
    List<StepFormVo> stepFormVos = this.stepFormVoService.findByStepCodes(stepCodes);
    if (CollectionUtils.isEmpty(stepCodes)) {
      return new ArrayList<>(0);
    }
    Map<String, StepFormVo> stepFormVoMap = stepFormVos.stream().collect(Collectors.toMap(StepFormVo::getStepCode, o -> o));
    for (HelpDefensePlanDetailPerformance performance : detailPerformances) {
      StepFormVo stepFormVo = stepFormVoMap.get(performance.getStepCode());
      if (stepFormVo != null) {
        performance.setStepName(stepFormVo.getStepName());
        performance.setLogos(stepFormVo.getLogos());
      }
      //组装步骤数据
      DynamicTemplateModelDto dynamicTemplateModelDto = new DynamicTemplateModelDto();
      dynamicTemplateModelDto.setParentCode(performance.getHelpDefensePlanDetailId());
      dynamicTemplateModelDto.setDynamicKey(performance.getStepCode());
      dynamicTemplateModelDto.setDynamicFormCode(performance.getFormCode());
      AbstractDynamicTemplateModel model = dynamicTemplateService.findByDynamicTemplateModelDto(dynamicTemplateModelDto);
      performance.setAbstractDynamicTemplateModel(model);
    }
    return detailPerformances;
  }

  /**
   * 创建验证
   *
   * @param helpDefensePlanDetailPerformance
   */
  private void createValidate(HelpDefensePlanDetailPerformance helpDefensePlanDetailPerformance) {
    Validate.notNull(helpDefensePlanDetailPerformance, "新增时，对象信息不能为空！");
    helpDefensePlanDetailPerformance.setId(null);
    Validate.notBlank(helpDefensePlanDetailPerformance.getHelpDefensePlanDetailId(), "新增数据时，协访计划明细id不能为空！");
    Validate.notBlank(helpDefensePlanDetailPerformance.getStepCode(), "新增数据时，步骤编码不能为空！");

  }
}

