package com.biz.crm.sfa.business.help.defense.local.service.strategy;

import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.help.defense.local.entity.HelpDefensePlanDetail;
import com.biz.crm.sfa.business.help.defense.local.entity.HelpDefensePlanDetailPerformance;
import com.biz.crm.sfa.business.help.defense.local.repository.HelpDefensePlanDetailRepository;
import com.biz.crm.sfa.business.help.defense.local.service.HelpDefensePlanDetailPerformanceService;
import com.biz.crm.sfa.business.help.defense.sdk.enums.HelpStatusEnum;
import com.biz.crm.sfa.business.step.sdk.enums.VisitTypeEnum;
import com.biz.crm.sfa.business.step.sdk.strategy.ExecutePlanCallBackStrategy;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 协访步骤完成情况回调监听事件实现类
 *
 * @author songjingen
 * @date 2022/6/21
 */
@Component
public class ExecutePlanCallBackStrategyForHelpDefense implements ExecutePlanCallBackStrategy {

  @Autowired
  private HelpDefensePlanDetailPerformanceService helpDefensePlanDetailPerformanceService;
  @Autowired
  private HelpDefensePlanDetailRepository helpDefensePlanDetailRepository;
  @Autowired(required = false)
  private LoginUserService loginUserService;

  @Override
  public String visitType() {
    return VisitTypeEnum.HELP_DEFENSE.getDictCode();
  }

  @Override
  public String visitName() {
    return VisitTypeEnum.HELP_DEFENSE.getValue();
  }

  @Transactional
  @Override
  public void onSave(String parentCode, String dynamicKey, String dynamicFormCode) {
    Validate.notBlank(parentCode, "保存完成情况时，父级关联唯一编码（明细id）不能为空！");
    Validate.notBlank(dynamicKey, "保存完成情况时，动态key（步骤编码）不能为空！");
    Validate.notBlank(dynamicFormCode, "保存完成情况时，表单编码不能为空！");
    HelpDefensePlanDetailPerformance helpDefensePlanDetailPerformance = new HelpDefensePlanDetailPerformance();
    helpDefensePlanDetailPerformance.setHelpDefensePlanDetailId(parentCode);
    helpDefensePlanDetailPerformance.setStepCode(dynamicKey);
    helpDefensePlanDetailPerformance.setFormCode(dynamicFormCode);
    this.helpDefensePlanDetailPerformanceService.create(helpDefensePlanDetailPerformance);
  }

  @Transactional
  @Override
  public void onUpdateExecuteStatus(Boolean completeOrNot, String parentCode) {
    Date planDateTime = new Date();
    HelpDefensePlanDetail helpDefensePlanDetail = this.helpDefensePlanDetailRepository.getById(parentCode);
    Validate.notNull(helpDefensePlanDetail, "更改协访状态时，未查询到相关的协访数据");
    if (completeOrNot) {
      helpDefensePlanDetail.setHelpStatus(HelpStatusEnum.COMPLETE.getDictCode());
      helpDefensePlanDetail.setHelpEndDate(planDateTime);
    } else {
      //验证是否存在相同时间的拜访中数据
      FacturerUserDetails loginDetails = this.loginUserService.getLoginDetails(FacturerUserDetails.class);
      List<HelpDefensePlanDetail> byUserNameAndVisitDate = this.helpDefensePlanDetailRepository.findByUserNameAndVisitDate(loginDetails.getAccount(), helpDefensePlanDetail.getHelpDate());
      List<HelpDefensePlanDetail> planDetails = byUserNameAndVisitDate.stream().filter(visitPlanDetail1 -> visitPlanDetail1.getHelpStatus().equals(HelpStatusEnum.IN.getDictCode())).collect(Collectors.toList());
      Validate.isTrue(CollectionUtils.isEmpty(planDetails), "存在协访中的计划，请完成后再次拜访！");
      helpDefensePlanDetail.setHelpStatus(HelpStatusEnum.IN.getDictCode());
      if (helpDefensePlanDetail.getHelpStartDate() == null) {
        helpDefensePlanDetail.setHelpStartDate(planDateTime);
      }
    }
    this.helpDefensePlanDetailRepository.saveOrUpdate(helpDefensePlanDetail);
  }

  @Override
  public Set<String> onFindUserNamesByNowAndExecuteStatusIn() {
    try {
      String nowDateStr = DateFormatUtils.format(new Date(), "yyyy-MM-dd");
      Date nowDate = DateUtils.parseDate(nowDateStr, "yyyy-MM-dd");
      Set<String> userNames = this.helpDefensePlanDetailRepository.findUserNamesByHelpStatusAndHelpDate(HelpStatusEnum.IN.getDictCode(), nowDate);
      return userNames;
    } catch (ParseException e) {
      e.printStackTrace();
    }
    return null;
  }
}
