package com.biz.crm.sfa.business.help.defense.sdk.dto;

import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 协访计划明细查询dto
 *
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "HelpDefensePlanDetailPageDto", description = "协访计划明细查询dto")
public class HelpDefensePlanDetailPageDto {

  /**
   * 租户编码
   */
  @ApiModelProperty("租户编码")
  private String tenantCode;

  /**
   * 协访人员账号
   */
  @ApiModelProperty("协访人员账号")
  private String helpUserName;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String clientCode;

  /**
   * 协防状态
   */
  @ApiModelProperty("协防状态")
  private String helpStatus;

  /**
   * 客户类型
   * {@link ClientTypeEnum#getDictCode()}
   */
  @ApiModelProperty("客户类型")
  private String clientType;

  /**
   * 客户维度
   * {@link ClientRouteRegister#getKey()}
   */
  @ApiModelProperty("客户维度")
  private String clientRoute;

  /**
   * 协访日期
   */
  @ApiModelProperty("协访日期")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date helpDate;

  /**
   * 协访开始时间
   */
  @ApiModelProperty("协访开始时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date helpStartDate;

  /**
   * 协访结束时间
   */
  @ApiModelProperty("协访结束时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date helpEndDate;


}
