package com.biz.crm.sfa.business.help.defense.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 协访计划制定查询dto
 *
 * @author songjingen
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "HelpDefenseQueryDto", description = "协访计划制定查询dto")
public class HelpDefenseQueryDto {

  /**
   * 租户编码
   */
  @ApiModelProperty("租户编码")
  private String tenantCode;

  /**
   * 协访计划编码
   */
  @ApiModelProperty("协访计划编码")
  private String helpPlanCode;
  /**
   * 协访人员账号
   */
  @ApiModelProperty("协访人员账号")
  private String helpUserName;

  /**
   * 协访日期
   */
  @ApiModelProperty("协访日期")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date helpDefenseDate;

  /**
   * 被协访人员账号
   */
  @ApiModelProperty("被协访人员账号")
  private String coverHelpUserName;

  /**
   * 协访人员名称
   */
  @ApiModelProperty("协访人员名称")
  private String helpRealName;

  /**
   * 被协访人员名称
   */
  @ApiModelProperty("被协访人员名称")
  private String coverHelpRealName;

}
