package com.biz.crm.sfa.business.help.defense.sdk.vo;

import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import com.biz.crm.sfa.business.client.sdk.register.ClientRouteRegister;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Entity;

/**
 * 协访计划客户信息表
 *
 * @author songjingen
 */
@Getter
@Setter
@Entity
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "HelpDefenseClientInfo", description = "协访计划客户信息表")
@org.hibernate.annotations.Table(appliesTo = "sfa_help_defense_client_info", comment = "协访计划客户信息表")
public class HelpDefenseClientInfoVo {

  private static final long serialVersionUID = -4442779125977878918L;

  /**
   * 协访计划编码
   */
  @ApiModelProperty("协访计划编码")
  private String helpPlanCode;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String clientCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String clientName;

  /**
   * 客户类型
   * {@link ClientTypeEnum#getDictCode()}
   */
  @ApiModelProperty("客户类型")
  private String clientType;

  /**
   * 客户维度
   * {@link ClientRouteRegister#getKey()}
   */
  @ApiModelProperty("客户维度")
  private String clientRoute;

}
