package com.biz.crm.sfa.business.help.defense.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 协访计划制定Vo
 *
 * @author songjingen
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "HelpDefenseVo", description = "协访计划制定Vo")
public class HelpDefenseVo extends TenantFlagOpVo {

  private static final long serialVersionUID = -4442779125977878918L;

  /**
   * 协访计划编码
   */
  @ApiModelProperty("协访计划编码")
  private String helpPlanCode;
  /**
   * 协访人员账号
   */
  @ApiModelProperty("协访人员账号")
  private String helpUserName;

  /**
   * 协访人员姓名
   */
  @ApiModelProperty("人员姓名")
  private String helpRealName;

  /**
   * 协访人员职位编码
   */
  @ApiModelProperty("人员职位编码")
  private String helpPostCode;

  /**
   * 协访人员职位名称
   */
  @ApiModelProperty("人员职位名称")
  private String helpPostName;

  /**
   * 协访人员所属组织编码
   */
  @ApiModelProperty("人员所属组织编码")
  private String helpOrgCode;

  /**
   * 协访人员所属组织名称
   */
  @ApiModelProperty("人员所属组织名称")
  private String helpOrgName;
  /**
   * 协访日期
   */
  @ApiModelProperty("协访日期")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date helpDefenseDate;

  /**
   * 被协访人员账号
   */
  @ApiModelProperty("被协访人员账号")
  private String coverHelpUserName;

  /**
   * 被协访人员名称
   */
  @ApiModelProperty("被协访人员名称")
  private String coverHelpRealName;

  /**
   * 被协访人客户信息数量
   */
  @ApiModelProperty("被协访人客户信息数量")
  private Integer clientInfoCount;

  /**
   * 客户信息集合
   */
  @ApiModelProperty("客户信息集合")
  private List<HelpDefenseClientInfoVo> clientInfoVos;

}
