package com.biz.crm.sfa.business.help.defense.sdk.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.help.defense.sdk.dto.HelpDefenseQueryDto;
import com.biz.crm.sfa.business.help.defense.sdk.vo.HelpDefenseVo;
import org.springframework.data.domain.Pageable;

/**
 * 协访计划制定表(HelpDefense)表服务接口
 *
 * @author songjingen
 * @since 2022-05-19 11:21:57
 */
public interface HelpDefenseVoService {

  /**
   * 分页查询数据
   *
   * @param pageable 分页对象
   * @param dto      实体对象
   * @return
   */
  Page<HelpDefenseVo> findByConditions(Pageable pageable, HelpDefenseQueryDto dto);

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  HelpDefenseVo findById(String id);

  /**
   * 通过plancode查询单条数据
   *
   * @param code plancode
   * @return 单条数据
   */
  HelpDefenseVo findByPlanCode(String code);
}

