package com.biz.crm.sfa.business.help.defense.sdk.vo;

import com.biz.crm.business.common.sdk.vo.UuidOpVo;
import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import com.biz.crm.sfa.business.client.sdk.register.ClientRouteRegister;
import com.biz.crm.sfa.business.client.sdk.vo.ClientContactVo;
import com.biz.crm.sfa.business.help.defense.sdk.enums.HelpStatusEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Entity;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 协访计划明细 实体类
 *
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@ApiModel(value = "HelpDefensePlanDetailVo", description = "协访计划明细表")
public class HelpDefensePlanDetailVo extends UuidOpVo {

  private static final long serialVersionUID = 7022214277071025864L;
  /**
   * 协访计划编码
   */
  @ApiModelProperty("协访计划编码")
  private String helpPlanCode;


  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String clientCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String clientName;

  /**
   * 客户类型
   * {@link ClientTypeEnum#getDictCode()}
   */
  @ApiModelProperty("客户类型")
  private String clientType;

  /**
   * 客户维度
   * {@link ClientRouteRegister#getKey()}
   */
  @ApiModelProperty("客户维度")
  private String clientRoute;

  /**
   * 客户细类
   */
  @ApiModelProperty("客户细类")
  private String clientSubName;

  /**
   * 协访状态
   * {@link HelpStatusEnum#getDictCode()}
   */
  @ApiModelProperty("协访状态")
  private String helpStatus;

  /**
   * 协访日期
   */
  @ApiModelProperty("协访日期")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date helpDate;

  /**
   * 经度
   */
  @ApiModelProperty("经度")
  private BigDecimal longitude;

  /**
   * 纬度
   */
  @ApiModelProperty("纬度")
  private BigDecimal latitude;

  /**
   * 客户地址
   */
  @ApiModelProperty("客户地址")
  private String clientAddress;

  /**
   * 联系人列表
   */
  @ApiModelProperty("联系人列表")
  private List<ClientContactVo> contactList;

  /**
   * 被协访人员账号
   */
  @ApiModelProperty("被协访人员账号")
  private String coverHelpUserName;

  /**
   * 协访人员账号
   */
  @ApiModelProperty("协访人员账号")
  private String helpUserName;

}
