package com.biz.crm.sfa.business.holiday.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.holiday.local.entity.HolidayEntity;
import com.biz.crm.sfa.business.holiday.local.service.HolidayService;
import com.biz.crm.sfa.business.holiday.sdk.dto.HolidayDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 节假日: Holiday: 节假日配置
 *
 * @author ning.zhang
 * @date 2022/5/5
 */
@Slf4j
@RestController
@RequestMapping("/v1/holiday/holiday")
@Api(tags = "节假日: Holiday: 节假日配置")
public class HolidayController {

  @Autowired
  private HolidayService holidayService;

  /**
   * 新增节假日信息
   *
   * @param dto 参数dto
   * @return 新增节假日数据
   */
  @ApiOperation(value = "新增节假日")
  @PostMapping("")
  public Result<HolidayEntity> create(@RequestBody HolidayDto dto) {
    try {
      return Result.ok(this.holidayService.create(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新节假日信息
   *
   * @param dto 参数dto
   * @return 更新后节假日数据
   */
  @ApiOperation(value = "更新节假日信息")
  @PatchMapping("")
  public Result<HolidayEntity> update(@RequestBody HolidayDto dto) {
    try {
      return Result.ok(this.holidayService.update(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 删除节假日
   *
   * @param ids 节假日id集合
   * @return 操作结果
   */
  @ApiOperation(value = "删除")
  @DeleteMapping("/deleteBatch")
  public Result deleteBatch(@RequestParam("ids") List<String> ids) {
    try {
      this.holidayService.deleteBatch(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
