package com.biz.crm.sfa.business.holiday.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.holiday.sdk.dto.HolidayPageDto;
import com.biz.crm.sfa.business.holiday.sdk.service.HolidayVoService;
import com.biz.crm.sfa.business.holiday.sdk.vo.HolidayVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 节假日: HolidayVo: 节假日配置
 *
 * @author ning.zhang
 * @date 2022/5/5
 */
@Slf4j
@RestController
@RequestMapping("/v1/holiday/holiday")
@Api(tags = "节假日: HolidayVo: 节假日配置")
public class HolidayVoController {

  @Autowired
  private HolidayVoService holidayVoService;

  /**
   * 通过ID获取节假日详细信息
   *
   * @param id 节假日ID
   * @return 节假日信息
   */
  @ApiOperation(value = "通过ID获取节假日详细信息")
  @GetMapping("/findById")
  public Result<HolidayVo> findById(@RequestParam(value = "id", required = false) @ApiParam(name = "id", value = "主键ID") String id) {
    try {
      return Result.ok(this.holidayVoService.findById(id));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 节假日分页查询
   *
   * @param pageable 分页信息
   * @param dto      参数Dto
   * @return 节假日分页数据
   */
  @ApiOperation(value = "节假日分页查询")
  @GetMapping("/findByConditions")
  public Result<Page<HolidayVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                  @ApiParam(name = "HolidayPageDto", value = "分页Dto") HolidayPageDto dto) {
    try {
      return Result.ok(this.holidayVoService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }



  /**
   * 查询年份列表
   * @return
   */
  @ApiOperation(value = "查询年份列表")
  @GetMapping("/findYearList")
  public Result<List<String>> findYearList(){
    Result result = new Result();
    List<String> yearList = this.holidayVoService.findYearList();
    result.setResult(yearList);
    return result;
  }
}
