package com.biz.crm.sfa.business.holiday.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 节假日日期实体类
 *
 * @author ning.zhang
 * @date 2022/5/11
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "HolidayDateEntity", description = "节假日日期实体类")
@Entity
@TableName("sfa_holiday_date")
@Table(name = "sfa_holiday_date", indexes = {
    @Index(name = "sfa_holiday_date_index1", columnList = "holiday_id"),
    @Index(name = "sfa_holiday_date_index2", columnList = "holiday_date"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_holiday_date", comment = "节假日日期表")
public class HolidayDateEntity extends UuidOpEntity {

  private static final long serialVersionUID = -4959079019764732882L;

  /**
   * 节假日ID
   */
  @ApiModelProperty("节假日ID")
  @Column(name = "holiday_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '节假日ID'")
  private String holidayId;

  /**
   * 节日日期
   */
  @ApiModelProperty("节日日期")
  @Column(name = "holiday_date", length = 10, nullable = false, columnDefinition = "VARCHAR(10) NOT NULL COMMENT '节日日期'")
  private String holidayDate;

  /**
   * 是否计算薪资(Y:是;N:否)
   * @see com.biz.crm.business.common.sdk.enums.BooleanEnum
   */
  @ApiModelProperty("是否计算薪资(Y:是;N:否)")
  @Column(name = "calculation_salary", length = 10, nullable = false, columnDefinition = "VARCHAR(10) NOT NULL COMMENT '是否计算薪资(Y:是;N:否)'")
  private String calculationSalary;

  /**
   * 节假日名称
   */
  @ApiModelProperty("节假日名称")
  @Column(name = "holiday_name", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '节假日名称'")
  private String holidayName;
}
